/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of parameters for this mitigation action. You can specify only one type of parameter (in other words, you can
 * apply only one action for each defined mitigation action).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MitigationActionParams implements SdkPojo, Serializable,
        ToCopyableBuilder<MitigationActionParams.Builder, MitigationActionParams> {
    private static final SdkField<UpdateDeviceCertificateParams> UPDATE_DEVICE_CERTIFICATE_PARAMS_FIELD = SdkField
            .<UpdateDeviceCertificateParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(MitigationActionParams::updateDeviceCertificateParams))
            .setter(setter(Builder::updateDeviceCertificateParams))
            .constructor(UpdateDeviceCertificateParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDeviceCertificateParams")
                    .build()).build();

    private static final SdkField<UpdateCACertificateParams> UPDATE_CA_CERTIFICATE_PARAMS_FIELD = SdkField
            .<UpdateCACertificateParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(MitigationActionParams::updateCACertificateParams)).setter(setter(Builder::updateCACertificateParams))
            .constructor(UpdateCACertificateParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateCACertificateParams").build())
            .build();

    private static final SdkField<AddThingsToThingGroupParams> ADD_THINGS_TO_THING_GROUP_PARAMS_FIELD = SdkField
            .<AddThingsToThingGroupParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(MitigationActionParams::addThingsToThingGroupParams))
            .setter(setter(Builder::addThingsToThingGroupParams))
            .constructor(AddThingsToThingGroupParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addThingsToThingGroupParams")
                    .build()).build();

    private static final SdkField<ReplaceDefaultPolicyVersionParams> REPLACE_DEFAULT_POLICY_VERSION_PARAMS_FIELD = SdkField
            .<ReplaceDefaultPolicyVersionParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(MitigationActionParams::replaceDefaultPolicyVersionParams))
            .setter(setter(Builder::replaceDefaultPolicyVersionParams))
            .constructor(ReplaceDefaultPolicyVersionParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replaceDefaultPolicyVersionParams")
                    .build()).build();

    private static final SdkField<EnableIoTLoggingParams> ENABLE_IO_T_LOGGING_PARAMS_FIELD = SdkField
            .<EnableIoTLoggingParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(MitigationActionParams::enableIoTLoggingParams)).setter(setter(Builder::enableIoTLoggingParams))
            .constructor(EnableIoTLoggingParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableIoTLoggingParams").build())
            .build();

    private static final SdkField<PublishFindingToSnsParams> PUBLISH_FINDING_TO_SNS_PARAMS_FIELD = SdkField
            .<PublishFindingToSnsParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(MitigationActionParams::publishFindingToSnsParams)).setter(setter(Builder::publishFindingToSnsParams))
            .constructor(PublishFindingToSnsParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishFindingToSnsParams").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            UPDATE_DEVICE_CERTIFICATE_PARAMS_FIELD, UPDATE_CA_CERTIFICATE_PARAMS_FIELD, ADD_THINGS_TO_THING_GROUP_PARAMS_FIELD,
            REPLACE_DEFAULT_POLICY_VERSION_PARAMS_FIELD, ENABLE_IO_T_LOGGING_PARAMS_FIELD, PUBLISH_FINDING_TO_SNS_PARAMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final UpdateDeviceCertificateParams updateDeviceCertificateParams;

    private final UpdateCACertificateParams updateCACertificateParams;

    private final AddThingsToThingGroupParams addThingsToThingGroupParams;

    private final ReplaceDefaultPolicyVersionParams replaceDefaultPolicyVersionParams;

    private final EnableIoTLoggingParams enableIoTLoggingParams;

    private final PublishFindingToSnsParams publishFindingToSnsParams;

    private MitigationActionParams(BuilderImpl builder) {
        this.updateDeviceCertificateParams = builder.updateDeviceCertificateParams;
        this.updateCACertificateParams = builder.updateCACertificateParams;
        this.addThingsToThingGroupParams = builder.addThingsToThingGroupParams;
        this.replaceDefaultPolicyVersionParams = builder.replaceDefaultPolicyVersionParams;
        this.enableIoTLoggingParams = builder.enableIoTLoggingParams;
        this.publishFindingToSnsParams = builder.publishFindingToSnsParams;
    }

    /**
     * <p>
     * Parameters to define a mitigation action that changes the state of the device certificate to inactive.
     * </p>
     * 
     * @return Parameters to define a mitigation action that changes the state of the device certificate to inactive.
     */
    public UpdateDeviceCertificateParams updateDeviceCertificateParams() {
        return updateDeviceCertificateParams;
    }

    /**
     * <p>
     * Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
     * </p>
     * 
     * @return Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
     */
    public UpdateCACertificateParams updateCACertificateParams() {
        return updateCACertificateParams;
    }

    /**
     * <p>
     * Parameters to define a mitigation action that moves devices associated with a certificate to one or more
     * specified thing groups, typically for quarantine.
     * </p>
     * 
     * @return Parameters to define a mitigation action that moves devices associated with a certificate to one or more
     *         specified thing groups, typically for quarantine.
     */
    public AddThingsToThingGroupParams addThingsToThingGroupParams() {
        return addThingsToThingGroupParams;
    }

    /**
     * <p>
     * Parameters to define a mitigation action that adds a blank policy to restrict permissions.
     * </p>
     * 
     * @return Parameters to define a mitigation action that adds a blank policy to restrict permissions.
     */
    public ReplaceDefaultPolicyVersionParams replaceDefaultPolicyVersionParams() {
        return replaceDefaultPolicyVersionParams;
    }

    /**
     * <p>
     * Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.
     * </p>
     * 
     * @return Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.
     */
    public EnableIoTLoggingParams enableIoTLoggingParams() {
        return enableIoTLoggingParams;
    }

    /**
     * <p>
     * Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own custom
     * actions in response to the Amazon SNS messages.
     * </p>
     * 
     * @return Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your
     *         own custom actions in response to the Amazon SNS messages.
     */
    public PublishFindingToSnsParams publishFindingToSnsParams() {
        return publishFindingToSnsParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateDeviceCertificateParams());
        hashCode = 31 * hashCode + Objects.hashCode(updateCACertificateParams());
        hashCode = 31 * hashCode + Objects.hashCode(addThingsToThingGroupParams());
        hashCode = 31 * hashCode + Objects.hashCode(replaceDefaultPolicyVersionParams());
        hashCode = 31 * hashCode + Objects.hashCode(enableIoTLoggingParams());
        hashCode = 31 * hashCode + Objects.hashCode(publishFindingToSnsParams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MitigationActionParams)) {
            return false;
        }
        MitigationActionParams other = (MitigationActionParams) obj;
        return Objects.equals(updateDeviceCertificateParams(), other.updateDeviceCertificateParams())
                && Objects.equals(updateCACertificateParams(), other.updateCACertificateParams())
                && Objects.equals(addThingsToThingGroupParams(), other.addThingsToThingGroupParams())
                && Objects.equals(replaceDefaultPolicyVersionParams(), other.replaceDefaultPolicyVersionParams())
                && Objects.equals(enableIoTLoggingParams(), other.enableIoTLoggingParams())
                && Objects.equals(publishFindingToSnsParams(), other.publishFindingToSnsParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MitigationActionParams").add("UpdateDeviceCertificateParams", updateDeviceCertificateParams())
                .add("UpdateCACertificateParams", updateCACertificateParams())
                .add("AddThingsToThingGroupParams", addThingsToThingGroupParams())
                .add("ReplaceDefaultPolicyVersionParams", replaceDefaultPolicyVersionParams())
                .add("EnableIoTLoggingParams", enableIoTLoggingParams())
                .add("PublishFindingToSnsParams", publishFindingToSnsParams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateDeviceCertificateParams":
            return Optional.ofNullable(clazz.cast(updateDeviceCertificateParams()));
        case "updateCACertificateParams":
            return Optional.ofNullable(clazz.cast(updateCACertificateParams()));
        case "addThingsToThingGroupParams":
            return Optional.ofNullable(clazz.cast(addThingsToThingGroupParams()));
        case "replaceDefaultPolicyVersionParams":
            return Optional.ofNullable(clazz.cast(replaceDefaultPolicyVersionParams()));
        case "enableIoTLoggingParams":
            return Optional.ofNullable(clazz.cast(enableIoTLoggingParams()));
        case "publishFindingToSnsParams":
            return Optional.ofNullable(clazz.cast(publishFindingToSnsParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MitigationActionParams, T> g) {
        return obj -> g.apply((MitigationActionParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MitigationActionParams> {
        /**
         * <p>
         * Parameters to define a mitigation action that changes the state of the device certificate to inactive.
         * </p>
         * 
         * @param updateDeviceCertificateParams
         *        Parameters to define a mitigation action that changes the state of the device certificate to inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDeviceCertificateParams(UpdateDeviceCertificateParams updateDeviceCertificateParams);

        /**
         * <p>
         * Parameters to define a mitigation action that changes the state of the device certificate to inactive.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateDeviceCertificateParams.Builder} avoiding
         * the need to create one manually via {@link UpdateDeviceCertificateParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateDeviceCertificateParams.Builder#build()} is called
         * immediately and its result is passed to {@link #updateDeviceCertificateParams(UpdateDeviceCertificateParams)}
         * .
         * 
         * @param updateDeviceCertificateParams
         *        a consumer that will call methods on {@link UpdateDeviceCertificateParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateDeviceCertificateParams(UpdateDeviceCertificateParams)
         */
        default Builder updateDeviceCertificateParams(
                Consumer<UpdateDeviceCertificateParams.Builder> updateDeviceCertificateParams) {
            return updateDeviceCertificateParams(UpdateDeviceCertificateParams.builder()
                    .applyMutation(updateDeviceCertificateParams).build());
        }

        /**
         * <p>
         * Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
         * </p>
         * 
         * @param updateCACertificateParams
         *        Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateCACertificateParams(UpdateCACertificateParams updateCACertificateParams);

        /**
         * <p>
         * Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateCACertificateParams.Builder} avoiding the
         * need to create one manually via {@link UpdateCACertificateParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateCACertificateParams.Builder#build()} is called immediately
         * and its result is passed to {@link #updateCACertificateParams(UpdateCACertificateParams)}.
         * 
         * @param updateCACertificateParams
         *        a consumer that will call methods on {@link UpdateCACertificateParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateCACertificateParams(UpdateCACertificateParams)
         */
        default Builder updateCACertificateParams(Consumer<UpdateCACertificateParams.Builder> updateCACertificateParams) {
            return updateCACertificateParams(UpdateCACertificateParams.builder().applyMutation(updateCACertificateParams).build());
        }

        /**
         * <p>
         * Parameters to define a mitigation action that moves devices associated with a certificate to one or more
         * specified thing groups, typically for quarantine.
         * </p>
         * 
         * @param addThingsToThingGroupParams
         *        Parameters to define a mitigation action that moves devices associated with a certificate to one or
         *        more specified thing groups, typically for quarantine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addThingsToThingGroupParams(AddThingsToThingGroupParams addThingsToThingGroupParams);

        /**
         * <p>
         * Parameters to define a mitigation action that moves devices associated with a certificate to one or more
         * specified thing groups, typically for quarantine.
         * </p>
         * This is a convenience that creates an instance of the {@link AddThingsToThingGroupParams.Builder} avoiding
         * the need to create one manually via {@link AddThingsToThingGroupParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link AddThingsToThingGroupParams.Builder#build()} is called
         * immediately and its result is passed to {@link #addThingsToThingGroupParams(AddThingsToThingGroupParams)}.
         * 
         * @param addThingsToThingGroupParams
         *        a consumer that will call methods on {@link AddThingsToThingGroupParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addThingsToThingGroupParams(AddThingsToThingGroupParams)
         */
        default Builder addThingsToThingGroupParams(Consumer<AddThingsToThingGroupParams.Builder> addThingsToThingGroupParams) {
            return addThingsToThingGroupParams(AddThingsToThingGroupParams.builder().applyMutation(addThingsToThingGroupParams)
                    .build());
        }

        /**
         * <p>
         * Parameters to define a mitigation action that adds a blank policy to restrict permissions.
         * </p>
         * 
         * @param replaceDefaultPolicyVersionParams
         *        Parameters to define a mitigation action that adds a blank policy to restrict permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParams replaceDefaultPolicyVersionParams);

        /**
         * <p>
         * Parameters to define a mitigation action that adds a blank policy to restrict permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplaceDefaultPolicyVersionParams.Builder}
         * avoiding the need to create one manually via {@link ReplaceDefaultPolicyVersionParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplaceDefaultPolicyVersionParams.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParams)}.
         * 
         * @param replaceDefaultPolicyVersionParams
         *        a consumer that will call methods on {@link ReplaceDefaultPolicyVersionParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParams)
         */
        default Builder replaceDefaultPolicyVersionParams(
                Consumer<ReplaceDefaultPolicyVersionParams.Builder> replaceDefaultPolicyVersionParams) {
            return replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParams.builder()
                    .applyMutation(replaceDefaultPolicyVersionParams).build());
        }

        /**
         * <p>
         * Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.
         * </p>
         * 
         * @param enableIoTLoggingParams
         *        Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIoTLoggingParams(EnableIoTLoggingParams enableIoTLoggingParams);

        /**
         * <p>
         * Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.
         * </p>
         * This is a convenience that creates an instance of the {@link EnableIoTLoggingParams.Builder} avoiding the
         * need to create one manually via {@link EnableIoTLoggingParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnableIoTLoggingParams.Builder#build()} is called immediately and
         * its result is passed to {@link #enableIoTLoggingParams(EnableIoTLoggingParams)}.
         * 
         * @param enableIoTLoggingParams
         *        a consumer that will call methods on {@link EnableIoTLoggingParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableIoTLoggingParams(EnableIoTLoggingParams)
         */
        default Builder enableIoTLoggingParams(Consumer<EnableIoTLoggingParams.Builder> enableIoTLoggingParams) {
            return enableIoTLoggingParams(EnableIoTLoggingParams.builder().applyMutation(enableIoTLoggingParams).build());
        }

        /**
         * <p>
         * Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own
         * custom actions in response to the Amazon SNS messages.
         * </p>
         * 
         * @param publishFindingToSnsParams
         *        Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your
         *        own custom actions in response to the Amazon SNS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishFindingToSnsParams(PublishFindingToSnsParams publishFindingToSnsParams);

        /**
         * <p>
         * Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own
         * custom actions in response to the Amazon SNS messages.
         * </p>
         * This is a convenience that creates an instance of the {@link PublishFindingToSnsParams.Builder} avoiding the
         * need to create one manually via {@link PublishFindingToSnsParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublishFindingToSnsParams.Builder#build()} is called immediately
         * and its result is passed to {@link #publishFindingToSnsParams(PublishFindingToSnsParams)}.
         * 
         * @param publishFindingToSnsParams
         *        a consumer that will call methods on {@link PublishFindingToSnsParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publishFindingToSnsParams(PublishFindingToSnsParams)
         */
        default Builder publishFindingToSnsParams(Consumer<PublishFindingToSnsParams.Builder> publishFindingToSnsParams) {
            return publishFindingToSnsParams(PublishFindingToSnsParams.builder().applyMutation(publishFindingToSnsParams).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateDeviceCertificateParams updateDeviceCertificateParams;

        private UpdateCACertificateParams updateCACertificateParams;

        private AddThingsToThingGroupParams addThingsToThingGroupParams;

        private ReplaceDefaultPolicyVersionParams replaceDefaultPolicyVersionParams;

        private EnableIoTLoggingParams enableIoTLoggingParams;

        private PublishFindingToSnsParams publishFindingToSnsParams;

        private BuilderImpl() {
        }

        private BuilderImpl(MitigationActionParams model) {
            updateDeviceCertificateParams(model.updateDeviceCertificateParams);
            updateCACertificateParams(model.updateCACertificateParams);
            addThingsToThingGroupParams(model.addThingsToThingGroupParams);
            replaceDefaultPolicyVersionParams(model.replaceDefaultPolicyVersionParams);
            enableIoTLoggingParams(model.enableIoTLoggingParams);
            publishFindingToSnsParams(model.publishFindingToSnsParams);
        }

        public final UpdateDeviceCertificateParams.Builder getUpdateDeviceCertificateParams() {
            return updateDeviceCertificateParams != null ? updateDeviceCertificateParams.toBuilder() : null;
        }

        @Override
        public final Builder updateDeviceCertificateParams(UpdateDeviceCertificateParams updateDeviceCertificateParams) {
            this.updateDeviceCertificateParams = updateDeviceCertificateParams;
            return this;
        }

        public final void setUpdateDeviceCertificateParams(UpdateDeviceCertificateParams.BuilderImpl updateDeviceCertificateParams) {
            this.updateDeviceCertificateParams = updateDeviceCertificateParams != null ? updateDeviceCertificateParams.build()
                    : null;
        }

        public final UpdateCACertificateParams.Builder getUpdateCACertificateParams() {
            return updateCACertificateParams != null ? updateCACertificateParams.toBuilder() : null;
        }

        @Override
        public final Builder updateCACertificateParams(UpdateCACertificateParams updateCACertificateParams) {
            this.updateCACertificateParams = updateCACertificateParams;
            return this;
        }

        public final void setUpdateCACertificateParams(UpdateCACertificateParams.BuilderImpl updateCACertificateParams) {
            this.updateCACertificateParams = updateCACertificateParams != null ? updateCACertificateParams.build() : null;
        }

        public final AddThingsToThingGroupParams.Builder getAddThingsToThingGroupParams() {
            return addThingsToThingGroupParams != null ? addThingsToThingGroupParams.toBuilder() : null;
        }

        @Override
        public final Builder addThingsToThingGroupParams(AddThingsToThingGroupParams addThingsToThingGroupParams) {
            this.addThingsToThingGroupParams = addThingsToThingGroupParams;
            return this;
        }

        public final void setAddThingsToThingGroupParams(AddThingsToThingGroupParams.BuilderImpl addThingsToThingGroupParams) {
            this.addThingsToThingGroupParams = addThingsToThingGroupParams != null ? addThingsToThingGroupParams.build() : null;
        }

        public final ReplaceDefaultPolicyVersionParams.Builder getReplaceDefaultPolicyVersionParams() {
            return replaceDefaultPolicyVersionParams != null ? replaceDefaultPolicyVersionParams.toBuilder() : null;
        }

        @Override
        public final Builder replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParams replaceDefaultPolicyVersionParams) {
            this.replaceDefaultPolicyVersionParams = replaceDefaultPolicyVersionParams;
            return this;
        }

        public final void setReplaceDefaultPolicyVersionParams(
                ReplaceDefaultPolicyVersionParams.BuilderImpl replaceDefaultPolicyVersionParams) {
            this.replaceDefaultPolicyVersionParams = replaceDefaultPolicyVersionParams != null ? replaceDefaultPolicyVersionParams
                    .build() : null;
        }

        public final EnableIoTLoggingParams.Builder getEnableIoTLoggingParams() {
            return enableIoTLoggingParams != null ? enableIoTLoggingParams.toBuilder() : null;
        }

        @Override
        public final Builder enableIoTLoggingParams(EnableIoTLoggingParams enableIoTLoggingParams) {
            this.enableIoTLoggingParams = enableIoTLoggingParams;
            return this;
        }

        public final void setEnableIoTLoggingParams(EnableIoTLoggingParams.BuilderImpl enableIoTLoggingParams) {
            this.enableIoTLoggingParams = enableIoTLoggingParams != null ? enableIoTLoggingParams.build() : null;
        }

        public final PublishFindingToSnsParams.Builder getPublishFindingToSnsParams() {
            return publishFindingToSnsParams != null ? publishFindingToSnsParams.toBuilder() : null;
        }

        @Override
        public final Builder publishFindingToSnsParams(PublishFindingToSnsParams publishFindingToSnsParams) {
            this.publishFindingToSnsParams = publishFindingToSnsParams;
            return this;
        }

        public final void setPublishFindingToSnsParams(PublishFindingToSnsParams.BuilderImpl publishFindingToSnsParams) {
            this.publishFindingToSnsParams = publishFindingToSnsParams != null ? publishFindingToSnsParams.build() : null;
        }

        @Override
        public MitigationActionParams build() {
            return new MitigationActionParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
