/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchAction.getter(ElasticsearchAction::roleArn)).setter(ElasticsearchAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchAction.getter(ElasticsearchAction::endpoint)).setter(ElasticsearchAction.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchAction.getter(ElasticsearchAction::index)).setter(ElasticsearchAction.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchAction.getter(ElasticsearchAction::type)).setter(ElasticsearchAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchAction.getter(ElasticsearchAction::id)).setter(ElasticsearchAction.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, ENDPOINT_FIELD, INDEX_FIELD, TYPE_FIELD, ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String endpoint;
    private final String index;
    private final String type;
    private final String id;

    private ElasticsearchAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.endpoint = builder.endpoint;
        this.index = builder.index;
        this.type = builder.type;
        this.id = builder.id;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchAction)) {
            return false;
        }
        ElasticsearchAction other = (ElasticsearchAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.index(), other.index()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchAction").add("RoleArn", (Object)this.roleArn()).add("Endpoint", (Object)this.endpoint()).add("Index", (Object)this.index()).add("Type", (Object)this.type()).add("Id", (Object)this.id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchAction, T> g) {
        return obj -> g.apply((ElasticsearchAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String endpoint;
        private String index;
        private String type;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchAction model) {
            this.roleArn(model.roleArn);
            this.endpoint(model.endpoint);
            this.index(model.index);
            this.type(model.type);
            this.id(model.id);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public ElasticsearchAction build() {
            return new ElasticsearchAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchAction> {
        public Builder roleArn(String var1);

        public Builder endpoint(String var1);

        public Builder index(String var1);

        public Builder type(String var1);

        public Builder id(String var1);
    }
}

