/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A map of key-value pairs for all supported statistics. Currently, only count is supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statistics implements SdkPojo, Serializable, ToCopyableBuilder<Statistics.Builder, Statistics> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Statistics::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Double> AVERAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::average)).setter(setter(Builder::average))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()).build();

    private static final SdkField<Double> SUM_OF_SQUARES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::sumOfSquares)).setter(setter(Builder::sumOfSquares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumOfSquares").build()).build();

    private static final SdkField<Double> VARIANCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::variance)).setter(setter(Builder::variance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variance").build()).build();

    private static final SdkField<Double> STD_DEVIATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Statistics::stdDeviation)).setter(setter(Builder::stdDeviation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stdDeviation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, AVERAGE_FIELD,
            SUM_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD, SUM_OF_SQUARES_FIELD, VARIANCE_FIELD, STD_DEVIATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final Double average;

    private final Double sum;

    private final Double minimum;

    private final Double maximum;

    private final Double sumOfSquares;

    private final Double variance;

    private final Double stdDeviation;

    private Statistics(BuilderImpl builder) {
        this.count = builder.count;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.sumOfSquares = builder.sumOfSquares;
        this.variance = builder.variance;
        this.stdDeviation = builder.stdDeviation;
    }

    /**
     * <p>
     * The count of things that match the query.
     * </p>
     * 
     * @return The count of things that match the query.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The average of the aggregated field values.
     * </p>
     * 
     * @return The average of the aggregated field values.
     */
    public Double average() {
        return average;
    }

    /**
     * <p>
     * The sum of the aggregated field values.
     * </p>
     * 
     * @return The sum of the aggregated field values.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The minimum aggregated field value.
     * </p>
     * 
     * @return The minimum aggregated field value.
     */
    public Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum aggregated field value.
     * </p>
     * 
     * @return The maximum aggregated field value.
     */
    public Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * The sum of the squares of the aggregated field values.
     * </p>
     * 
     * @return The sum of the squares of the aggregated field values.
     */
    public Double sumOfSquares() {
        return sumOfSquares;
    }

    /**
     * <p>
     * The variance of the aggregated field values.
     * </p>
     * 
     * @return The variance of the aggregated field values.
     */
    public Double variance() {
        return variance;
    }

    /**
     * <p>
     * The standard deviation of the aggregated field values.
     * </p>
     * 
     * @return The standard deviation of the aggregated field values.
     */
    public Double stdDeviation() {
        return stdDeviation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(average());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(sumOfSquares());
        hashCode = 31 * hashCode + Objects.hashCode(variance());
        hashCode = 31 * hashCode + Objects.hashCode(stdDeviation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(average(), other.average())
                && Objects.equals(sum(), other.sum()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(maximum(), other.maximum()) && Objects.equals(sumOfSquares(), other.sumOfSquares())
                && Objects.equals(variance(), other.variance()) && Objects.equals(stdDeviation(), other.stdDeviation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Statistics").add("Count", count()).add("Average", average()).add("Sum", sum())
                .add("Minimum", minimum()).add("Maximum", maximum()).add("SumOfSquares", sumOfSquares())
                .add("Variance", variance()).add("StdDeviation", stdDeviation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "average":
            return Optional.ofNullable(clazz.cast(average()));
        case "sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "sumOfSquares":
            return Optional.ofNullable(clazz.cast(sumOfSquares()));
        case "variance":
            return Optional.ofNullable(clazz.cast(variance()));
        case "stdDeviation":
            return Optional.ofNullable(clazz.cast(stdDeviation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statistics> {
        /**
         * <p>
         * The count of things that match the query.
         * </p>
         * 
         * @param count
         *        The count of things that match the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The average of the aggregated field values.
         * </p>
         * 
         * @param average
         *        The average of the aggregated field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The sum of the aggregated field values.
         * </p>
         * 
         * @param sum
         *        The sum of the aggregated field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The minimum aggregated field value.
         * </p>
         * 
         * @param minimum
         *        The minimum aggregated field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The maximum aggregated field value.
         * </p>
         * 
         * @param maximum
         *        The maximum aggregated field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * The sum of the squares of the aggregated field values.
         * </p>
         * 
         * @param sumOfSquares
         *        The sum of the squares of the aggregated field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumOfSquares(Double sumOfSquares);

        /**
         * <p>
         * The variance of the aggregated field values.
         * </p>
         * 
         * @param variance
         *        The variance of the aggregated field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variance(Double variance);

        /**
         * <p>
         * The standard deviation of the aggregated field values.
         * </p>
         * 
         * @param stdDeviation
         *        The standard deviation of the aggregated field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stdDeviation(Double stdDeviation);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private Double average;

        private Double sum;

        private Double minimum;

        private Double maximum;

        private Double sumOfSquares;

        private Double variance;

        private Double stdDeviation;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            count(model.count);
            average(model.average);
            sum(model.sum);
            minimum(model.minimum);
            maximum(model.maximum);
            sumOfSquares(model.sumOfSquares);
            variance(model.variance);
            stdDeviation(model.stdDeviation);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Double getAverage() {
            return average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final Double getSumOfSquares() {
            return sumOfSquares;
        }

        @Override
        public final Builder sumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
            return this;
        }

        public final void setSumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
        }

        public final Double getVariance() {
            return variance;
        }

        @Override
        public final Builder variance(Double variance) {
            this.variance = variance;
            return this;
        }

        public final void setVariance(Double variance) {
            this.variance = variance;
        }

        public final Double getStdDeviation() {
            return stdDeviation;
        }

        @Override
        public final Builder stdDeviation(Double stdDeviation) {
            this.stdDeviation = stdDeviation;
            return this;
        }

        public final void setStdDeviation(Double stdDeviation) {
            this.stdDeviation = stdDeviation;
        }

        @Override
        public Statistics build() {
            return new Statistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
