/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListPolicyVersions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyVersionsResponse extends IotResponse implements
        ToCopyableBuilder<ListPolicyVersionsResponse.Builder, ListPolicyVersionsResponse> {
    private static final SdkField<List<PolicyVersion>> POLICY_VERSIONS_FIELD = SdkField
            .<List<PolicyVersion>> builder(MarshallingType.LIST)
            .getter(getter(ListPolicyVersionsResponse::policyVersions))
            .setter(setter(Builder::policyVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_VERSIONS_FIELD));

    private final List<PolicyVersion> policyVersions;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersions = builder.policyVersions;
    }

    /**
     * Returns true if the PolicyVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPolicyVersions() {
        return policyVersions != null && !(policyVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policy versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The policy versions.
     */
    public List<PolicyVersion> policyVersions() {
        return policyVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse) obj;
        return Objects.equals(policyVersions(), other.policyVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPolicyVersionsResponse").add("PolicyVersions", policyVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyVersions":
            return Optional.ofNullable(clazz.cast(policyVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyVersionsResponse, T> g) {
        return obj -> g.apply((ListPolicyVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        /**
         * <p>
         * The policy versions.
         * </p>
         * 
         * @param policyVersions
         *        The policy versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersions(Collection<PolicyVersion> policyVersions);

        /**
         * <p>
         * The policy versions.
         * </p>
         * 
         * @param policyVersions
         *        The policy versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersions(PolicyVersion... policyVersions);

        /**
         * <p>
         * The policy versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyVersion>.Builder} avoiding the need
         * to create one manually via {@link List<PolicyVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #policyVersions(List<PolicyVersion>)}.
         * 
         * @param policyVersions
         *        a consumer that will call methods on {@link List<PolicyVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersions(List<PolicyVersion>)
         */
        Builder policyVersions(Consumer<PolicyVersion.Builder>... policyVersions);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<PolicyVersion> policyVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            super(model);
            policyVersions(model.policyVersions);
        }

        public final Collection<PolicyVersion.Builder> getPolicyVersions() {
            return policyVersions != null ? policyVersions.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder policyVersions(Collection<PolicyVersion> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copy(policyVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(PolicyVersion... policyVersions) {
            policyVersions(Arrays.asList(policyVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(Consumer<PolicyVersion.Builder>... policyVersions) {
            policyVersions(Stream.of(policyVersions).map(c -> PolicyVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyVersions(Collection<PolicyVersion.BuilderImpl> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copyFromBuilder(policyVersions);
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
