/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DescribeCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCaCertificateRequest extends IotRequest implements
        ToCopyableBuilder<DescribeCaCertificateRequest.Builder, DescribeCaCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeCaCertificateRequest::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caCertificateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD));

    private final String certificateId;

    private DescribeCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
    }

    /**
     * <p>
     * The CA certificate identifier.
     * </p>
     * 
     * @return The CA certificate identifier.
     */
    public String certificateId() {
        return certificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCaCertificateRequest)) {
            return false;
        }
        DescribeCaCertificateRequest other = (DescribeCaCertificateRequest) obj;
        return Objects.equals(certificateId(), other.certificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCaCertificateRequest").add("CertificateId", certificateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCaCertificateRequest, T> g) {
        return obj -> g.apply((DescribeCaCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCaCertificateRequest> {
        /**
         * <p>
         * The CA certificate identifier.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCaCertificateRequest model) {
            super(model);
            certificateId(model.certificateId);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCaCertificateRequest build() {
            return new DescribeCaCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
