/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalMetricsToRetainListCopier;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.services.iot.model.AlertTargetType;
import software.amazon.awssdk.services.iot.model.AlertTargetsCopier;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityProfileRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::securityProfileName)).setter(UpdateSecurityProfileRequest.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::securityProfileDescription)).setter(UpdateSecurityProfileRequest.setter(Builder::securityProfileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build()}).build();
    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::behaviors)).setter(UpdateSecurityProfileRequest.setter(Builder::behaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::alertTargetsAsStrings)).setter(UpdateSecurityProfileRequest.setter(Builder::alertTargetsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlertTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::additionalMetricsToRetain)).setter(UpdateSecurityProfileRequest.setter(Builder::additionalMetricsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::deleteBehaviors)).setter(UpdateSecurityProfileRequest.setter(Builder::deleteBehaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteBehaviors").build()}).build();
    private static final SdkField<Boolean> DELETE_ALERT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::deleteAlertTargets)).setter(UpdateSecurityProfileRequest.setter(Builder::deleteAlertTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAlertTargets").build()}).build();
    private static final SdkField<Boolean> DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::deleteAdditionalMetricsToRetain)).setter(UpdateSecurityProfileRequest.setter(Builder::deleteAdditionalMetricsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAdditionalMetricsToRetain").build()}).build();
    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::expectedVersion)).setter(UpdateSecurityProfileRequest.setter(Builder::expectedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD, SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, ADDITIONAL_METRICS_TO_RETAIN_FIELD, DELETE_BEHAVIORS_FIELD, DELETE_ALERT_TARGETS_FIELD, DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD, EXPECTED_VERSION_FIELD));
    private final String securityProfileName;
    private final String securityProfileDescription;
    private final List<Behavior> behaviors;
    private final Map<String, AlertTarget> alertTargets;
    private final List<String> additionalMetricsToRetain;
    private final Boolean deleteBehaviors;
    private final Boolean deleteAlertTargets;
    private final Boolean deleteAdditionalMetricsToRetain;
    private final Long expectedVersion;

    private UpdateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.deleteBehaviors = builder.deleteBehaviors;
        this.deleteAlertTargets = builder.deleteAlertTargets;
        this.deleteAdditionalMetricsToRetain = builder.deleteAdditionalMetricsToRetain;
        this.expectedVersion = builder.expectedVersion;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileDescription() {
        return this.securityProfileDescription;
    }

    public boolean hasBehaviors() {
        return this.behaviors != null && !(this.behaviors instanceof SdkAutoConstructList);
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(this.alertTargets);
    }

    public boolean hasAlertTargets() {
        return this.alertTargets != null && !(this.alertTargets instanceof SdkAutoConstructMap);
    }

    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return this.alertTargets;
    }

    public boolean hasAdditionalMetricsToRetain() {
        return this.additionalMetricsToRetain != null && !(this.additionalMetricsToRetain instanceof SdkAutoConstructList);
    }

    public List<String> additionalMetricsToRetain() {
        return this.additionalMetricsToRetain;
    }

    public Boolean deleteBehaviors() {
        return this.deleteBehaviors;
    }

    public Boolean deleteAlertTargets() {
        return this.deleteAlertTargets;
    }

    public Boolean deleteAdditionalMetricsToRetain() {
        return this.deleteAdditionalMetricsToRetain;
    }

    public Long expectedVersion() {
        return this.expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAlertTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAdditionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileDescription(), other.securityProfileDescription()) && Objects.equals(this.behaviors(), other.behaviors()) && Objects.equals(this.alertTargetsAsStrings(), other.alertTargetsAsStrings()) && Objects.equals(this.additionalMetricsToRetain(), other.additionalMetricsToRetain()) && Objects.equals(this.deleteBehaviors(), other.deleteBehaviors()) && Objects.equals(this.deleteAlertTargets(), other.deleteAlertTargets()) && Objects.equals(this.deleteAdditionalMetricsToRetain(), other.deleteAdditionalMetricsToRetain()) && Objects.equals(this.expectedVersion(), other.expectedVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecurityProfileRequest").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileDescription", (Object)this.securityProfileDescription()).add("Behaviors", this.behaviors()).add("AlertTargets", this.alertTargetsAsStrings()).add("AdditionalMetricsToRetain", this.additionalMetricsToRetain()).add("DeleteBehaviors", (Object)this.deleteBehaviors()).add("DeleteAlertTargets", (Object)this.deleteAlertTargets()).add("DeleteAdditionalMetricsToRetain", (Object)this.deleteAdditionalMetricsToRetain()).add("ExpectedVersion", (Object)this.expectedVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.securityProfileDescription()));
            }
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
            case "alertTargets": {
                return Optional.ofNullable(clazz.cast(this.alertTargetsAsStrings()));
            }
            case "additionalMetricsToRetain": {
                return Optional.ofNullable(clazz.cast(this.additionalMetricsToRetain()));
            }
            case "deleteBehaviors": {
                return Optional.ofNullable(clazz.cast(this.deleteBehaviors()));
            }
            case "deleteAlertTargets": {
                return Optional.ofNullable(clazz.cast(this.deleteAlertTargets()));
            }
            case "deleteAdditionalMetricsToRetain": {
                return Optional.ofNullable(clazz.cast(this.deleteAdditionalMetricsToRetain()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileRequest, T> g) {
        return obj -> g.apply((UpdateSecurityProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileDescription;
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();
        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteBehaviors;
        private Boolean deleteAlertTargets;
        private Boolean deleteAdditionalMetricsToRetain;
        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileRequest model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileDescription(model.securityProfileDescription);
            this.behaviors(model.behaviors);
            this.alertTargetsWithStrings(model.alertTargets);
            this.additionalMetricsToRetain(model.additionalMetricsToRetain);
            this.deleteBehaviors(model.deleteBehaviors);
            this.deleteAlertTargets(model.deleteAlertTargets);
            this.deleteAdditionalMetricsToRetain(model.deleteAdditionalMetricsToRetain);
            this.expectedVersion(model.expectedVersion);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargetsAsStrings() {
            return this.alertTargets != null ? CollectionUtils.mapValues(this.alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargetsWithStrings(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Collection<String> getAdditionalMetricsToRetain() {
            return this.additionalMetricsToRetain;
        }

        @Override
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetain(String ... additionalMetricsToRetain) {
            this.additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        public final Boolean getDeleteBehaviors() {
            return this.deleteBehaviors;
        }

        @Override
        public final Builder deleteBehaviors(Boolean deleteBehaviors) {
            this.deleteBehaviors = deleteBehaviors;
            return this;
        }

        public final void setDeleteBehaviors(Boolean deleteBehaviors) {
            this.deleteBehaviors = deleteBehaviors;
        }

        public final Boolean getDeleteAlertTargets() {
            return this.deleteAlertTargets;
        }

        @Override
        public final Builder deleteAlertTargets(Boolean deleteAlertTargets) {
            this.deleteAlertTargets = deleteAlertTargets;
            return this;
        }

        public final void setDeleteAlertTargets(Boolean deleteAlertTargets) {
            this.deleteAlertTargets = deleteAlertTargets;
        }

        public final Boolean getDeleteAdditionalMetricsToRetain() {
            return this.deleteAdditionalMetricsToRetain;
        }

        @Override
        public final Builder deleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
            this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
            return this;
        }

        public final void setDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
            this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityProfileRequest build() {
            return new UpdateSecurityProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityProfileRequest> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileDescription(String var1);

        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder alertTargetsWithStrings(Map<String, AlertTarget> var1);

        public Builder alertTargets(Map<AlertTargetType, AlertTarget> var1);

        public Builder additionalMetricsToRetain(Collection<String> var1);

        public Builder additionalMetricsToRetain(String ... var1);

        public Builder deleteBehaviors(Boolean var1);

        public Builder deleteAlertTargets(Boolean var1);

        public Builder deleteAdditionalMetricsToRetain(Boolean var1);

        public Builder expectedVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

