/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingGroupMetadata;
import software.amazon.awssdk.services.iot.model.ThingGroupProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeThingGroupResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeThingGroupResponse> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeThingGroupResponse.getter(DescribeThingGroupResponse::thingGroupName)).setter(DescribeThingGroupResponse.setter(Builder::thingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()}).build();
    private static final SdkField<String> THING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeThingGroupResponse.getter(DescribeThingGroupResponse::thingGroupId)).setter(DescribeThingGroupResponse.setter(Builder::thingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupId").build()}).build();
    private static final SdkField<String> THING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeThingGroupResponse.getter(DescribeThingGroupResponse::thingGroupArn)).setter(DescribeThingGroupResponse.setter(Builder::thingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupArn").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeThingGroupResponse.getter(DescribeThingGroupResponse::version)).setter(DescribeThingGroupResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeThingGroupResponse.getter(DescribeThingGroupResponse::thingGroupProperties)).setter(DescribeThingGroupResponse.setter(Builder::thingGroupProperties)).constructor(ThingGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build()}).build();
    private static final SdkField<ThingGroupMetadata> THING_GROUP_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeThingGroupResponse.getter(DescribeThingGroupResponse::thingGroupMetadata)).setter(DescribeThingGroupResponse.setter(Builder::thingGroupMetadata)).constructor(ThingGroupMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD, THING_GROUP_ID_FIELD, THING_GROUP_ARN_FIELD, VERSION_FIELD, THING_GROUP_PROPERTIES_FIELD, THING_GROUP_METADATA_FIELD));
    private final String thingGroupName;
    private final String thingGroupId;
    private final String thingGroupArn;
    private final Long version;
    private final ThingGroupProperties thingGroupProperties;
    private final ThingGroupMetadata thingGroupMetadata;

    private DescribeThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
        this.thingGroupArn = builder.thingGroupArn;
        this.version = builder.version;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.thingGroupMetadata = builder.thingGroupMetadata;
    }

    public String thingGroupName() {
        return this.thingGroupName;
    }

    public String thingGroupId() {
        return this.thingGroupId;
    }

    public String thingGroupArn() {
        return this.thingGroupArn;
    }

    public Long version() {
        return this.version;
    }

    public ThingGroupProperties thingGroupProperties() {
        return this.thingGroupProperties;
    }

    public ThingGroupMetadata thingGroupMetadata() {
        return this.thingGroupMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingGroupResponse)) {
            return false;
        }
        DescribeThingGroupResponse other = (DescribeThingGroupResponse)((Object)obj);
        return Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupId(), other.thingGroupId()) && Objects.equals(this.thingGroupArn(), other.thingGroupArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.thingGroupProperties(), other.thingGroupProperties()) && Objects.equals(this.thingGroupMetadata(), other.thingGroupMetadata());
    }

    public String toString() {
        return ToString.builder((String)"DescribeThingGroupResponse").add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupId", (Object)this.thingGroupId()).add("ThingGroupArn", (Object)this.thingGroupArn()).add("Version", (Object)this.version()).add("ThingGroupProperties", (Object)this.thingGroupProperties()).add("ThingGroupMetadata", (Object)this.thingGroupMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupId": {
                return Optional.ofNullable(clazz.cast(this.thingGroupId()));
            }
            case "thingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.thingGroupArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "thingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.thingGroupProperties()));
            }
            case "thingGroupMetadata": {
                return Optional.ofNullable(clazz.cast(this.thingGroupMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingGroupResponse, T> g) {
        return obj -> g.apply((DescribeThingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String thingGroupName;
        private String thingGroupId;
        private String thingGroupArn;
        private Long version;
        private ThingGroupProperties thingGroupProperties;
        private ThingGroupMetadata thingGroupMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingGroupResponse model) {
            super(model);
            this.thingGroupName(model.thingGroupName);
            this.thingGroupId(model.thingGroupId);
            this.thingGroupArn(model.thingGroupArn);
            this.version(model.version);
            this.thingGroupProperties(model.thingGroupProperties);
            this.thingGroupMetadata(model.thingGroupMetadata);
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupId() {
            return this.thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        public final String getThingGroupArn() {
            return this.thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return this.thingGroupProperties != null ? this.thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final ThingGroupMetadata.Builder getThingGroupMetadata() {
            return this.thingGroupMetadata != null ? this.thingGroupMetadata.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupMetadata(ThingGroupMetadata thingGroupMetadata) {
            this.thingGroupMetadata = thingGroupMetadata;
            return this;
        }

        public final void setThingGroupMetadata(ThingGroupMetadata.BuilderImpl thingGroupMetadata) {
            this.thingGroupMetadata = thingGroupMetadata != null ? thingGroupMetadata.build() : null;
        }

        @Override
        public DescribeThingGroupResponse build() {
            return new DescribeThingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeThingGroupResponse> {
        public Builder thingGroupName(String var1);

        public Builder thingGroupId(String var1);

        public Builder thingGroupArn(String var1);

        public Builder version(Long var1);

        public Builder thingGroupProperties(ThingGroupProperties var1);

        default public Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return this.thingGroupProperties((ThingGroupProperties)((ThingGroupProperties.Builder)ThingGroupProperties.builder().applyMutation(thingGroupProperties)).build());
        }

        public Builder thingGroupMetadata(ThingGroupMetadata var1);

        default public Builder thingGroupMetadata(Consumer<ThingGroupMetadata.Builder> thingGroupMetadata) {
            return this.thingGroupMetadata((ThingGroupMetadata)((ThingGroupMetadata.Builder)ThingGroupMetadata.builder().applyMutation(thingGroupMetadata)).build());
        }
    }
}

