/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.PolicyVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyVersionMarshaller {
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISDEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isDefaultVersion").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createDate").isBinary(false).build();
    private static final PolicyVersionMarshaller INSTANCE = new PolicyVersionMarshaller();

    private PolicyVersionMarshaller() {
    }

    public static PolicyVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyVersion policyVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyVersion, (String)"policyVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyVersion.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)policyVersion.isDefaultVersion(), ISDEFAULTVERSION_BINDING);
            protocolMarshaller.marshall((Object)policyVersion.createDate(), CREATEDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

