/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TopicRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TopicRuleMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleName").isBinary(false).build();
    private static final MarshallingInfo<String> SQL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sql").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").isBinary(false).build();
    private static final MarshallingInfo<Boolean> RULEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleDisabled").isBinary(false).build();
    private static final MarshallingInfo<String> AWSIOTSQLVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotSqlVersion").isBinary(false).build();
    private static final TopicRuleMarshaller INSTANCE = new TopicRuleMarshaller();

    private TopicRuleMarshaller() {
    }

    public static TopicRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicRule topicRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)topicRule, (String)"topicRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)topicRule.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)topicRule.sql(), SQL_BINDING);
            protocolMarshaller.marshall((Object)topicRule.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)topicRule.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(topicRule.actions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)topicRule.ruleDisabled(), RULEDISABLED_BINDING);
            protocolMarshaller.marshall((Object)topicRule.awsIotSqlVersion(), AWSIOTSQLVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

