/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ThingTypeDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingTypeDefinitionMarshaller {
    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> THINGTYPEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeProperties").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> THINGTYPEMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeMetadata").isBinary(false).build();
    private static final ThingTypeDefinitionMarshaller INSTANCE = new ThingTypeDefinitionMarshaller();

    private ThingTypeDefinitionMarshaller() {
    }

    public static ThingTypeDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingTypeDefinition thingTypeDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingTypeDefinition, (String)"thingTypeDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingTypeDefinition.thingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall((Object)thingTypeDefinition.thingTypeProperties(), THINGTYPEPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)thingTypeDefinition.thingTypeMetadata(), THINGTYPEMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

