/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.transform.GetPolicyVersionRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetPolicyVersionRequestMarshaller
implements Marshaller<Request<GetPolicyVersionRequest>, GetPolicyVersionRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/policies/{policyName}/version/{policyVersionId}").httpMethodName(HttpMethodName.GET).hasExplicitPayloadMember(false).hasPayloadMembers(false).build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetPolicyVersionRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetPolicyVersionRequest> marshall(GetPolicyVersionRequest getPolicyVersionRequest) {
        Validate.paramNotNull((Object)((Object)getPolicyVersionRequest), (String)"getPolicyVersionRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getPolicyVersionRequest);
            protocolMarshaller.startMarshalling();
            GetPolicyVersionRequestModelMarshaller.getInstance().marshall(getPolicyVersionRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

