/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DynamoDBActionMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tableName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operation").isBinary(false).build();
    private static final MarshallingInfo<String> HASHKEYFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyField").isBinary(false).build();
    private static final MarshallingInfo<String> HASHKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyValue").isBinary(false).build();
    private static final MarshallingInfo<String> HASHKEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyType").isBinary(false).build();
    private static final MarshallingInfo<String> RANGEKEYFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyField").isBinary(false).build();
    private static final MarshallingInfo<String> RANGEKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyValue").isBinary(false).build();
    private static final MarshallingInfo<String> RANGEKEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyType").isBinary(false).build();
    private static final MarshallingInfo<String> PAYLOADFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("payloadField").isBinary(false).build();
    private static final DynamoDBActionMarshaller INSTANCE = new DynamoDBActionMarshaller();

    private DynamoDBActionMarshaller() {
    }

    public static DynamoDBActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamoDBAction dynamoDBAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dynamoDBAction, (String)"dynamoDBAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dynamoDBAction.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.operation(), OPERATION_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.hashKeyField(), HASHKEYFIELD_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.hashKeyValue(), HASHKEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.hashKeyTypeAsString(), HASHKEYTYPE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.rangeKeyField(), RANGEKEYFIELD_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.rangeKeyValue(), RANGEKEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.rangeKeyTypeAsString(), RANGEKEYTYPE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.payloadField(), PAYLOADFIELD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

