/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.CertificateStatus;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterCertificateRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, RegisterCertificateRequest> {
    private final String certificatePem;
    private final String caCertificatePem;
    private final Boolean setAsActive;
    private final String status;

    private RegisterCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.caCertificatePem = builder.caCertificatePem;
        this.setAsActive = builder.setAsActive;
        this.status = builder.status;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public String caCertificatePem() {
        return this.caCertificatePem;
    }

    public Boolean setAsActive() {
        return this.setAsActive;
    }

    public CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateRequest)) {
            return false;
        }
        RegisterCertificateRequest other = (RegisterCertificateRequest)((Object)obj);
        return Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.caCertificatePem(), other.caCertificatePem()) && Objects.equals(this.setAsActive(), other.setAsActive()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"RegisterCertificateRequest").add("CertificatePem", (Object)this.certificatePem()).add("CaCertificatePem", (Object)this.caCertificatePem()).add("SetAsActive", (Object)this.setAsActive()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificatePem": {
                return Optional.of(clazz.cast(this.certificatePem()));
            }
            case "caCertificatePem": {
                return Optional.of(clazz.cast(this.caCertificatePem()));
            }
            case "setAsActive": {
                return Optional.of(clazz.cast(this.setAsActive()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String certificatePem;
        private String caCertificatePem;
        private Boolean setAsActive;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateRequest model) {
            super(model);
            this.certificatePem(model.certificatePem);
            this.caCertificatePem(model.caCertificatePem);
            this.setAsActive(model.setAsActive);
            this.status(model.status);
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getCaCertificatePem() {
            return this.caCertificatePem;
        }

        @Override
        public final Builder caCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
            return this;
        }

        public final void setCaCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
        }

        public final Boolean getSetAsActive() {
            return this.setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterCertificateRequest build() {
            return new RegisterCertificateRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, RegisterCertificateRequest> {
        public Builder certificatePem(String var1);

        public Builder caCertificatePem(String var1);

        public Builder setAsActive(Boolean var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

