/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.iot.model.CACertificate;
import software.amazon.awssdk.services.iot.model.CACertificatesCopier;
import software.amazon.awssdk.services.iot.model.IoTResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCACertificatesResponse
extends IoTResponse
implements ToCopyableBuilder<Builder, ListCACertificatesResponse> {
    private final List<CACertificate> certificates;
    private final String nextMarker;

    private ListCACertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    public List<CACertificate> certificates() {
        return this.certificates;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCACertificatesResponse)) {
            return false;
        }
        ListCACertificatesResponse other = (ListCACertificatesResponse)((Object)obj);
        return Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListCACertificatesResponse").add("Certificates", this.certificates()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificates": {
                return Optional.of(clazz.cast(this.certificates()));
            }
            case "nextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTResponse.BuilderImpl
    implements Builder {
        private List<CACertificate> certificates;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCACertificatesResponse model) {
            super(model);
            this.certificates(model.certificates);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<CACertificate.Builder> getCertificates() {
            return this.certificates != null ? (Collection)this.certificates.stream().map(CACertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(CACertificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<CACertificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (CACertificate)((CACertificate.Builder)CACertificate.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<CACertificate.BuilderImpl> certificates) {
            this.certificates = CACertificatesCopier.copyFromBuilder(certificates);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCACertificatesResponse build() {
            return new ListCACertificatesResponse(this);
        }
    }

    public static interface Builder
    extends IoTResponse.Builder,
    CopyableBuilder<Builder, ListCACertificatesResponse> {
        public Builder certificates(Collection<CACertificate> var1);

        public Builder certificates(CACertificate ... var1);

        public Builder certificates(Consumer<CACertificate.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

