/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.PutItemInput;
import software.amazon.awssdk.services.iot.transform.DynamoDBv2ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DynamoDBv2Action
implements StructuredPojo,
ToCopyableBuilder<Builder, DynamoDBv2Action> {
    private final String roleArn;
    private final PutItemInput putItem;

    private DynamoDBv2Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.putItem = builder.putItem;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public PutItemInput putItem() {
        return this.putItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.putItem());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBv2Action)) {
            return false;
        }
        DynamoDBv2Action other = (DynamoDBv2Action)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.putItem(), other.putItem());
    }

    public String toString() {
        return ToString.builder((String)"DynamoDBv2Action").add("RoleArn", (Object)this.roleArn()).add("PutItem", (Object)this.putItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "putItem": {
                return Optional.of(clazz.cast(this.putItem()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBv2ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private PutItemInput putItem;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBv2Action model) {
            this.roleArn(model.roleArn);
            this.putItem(model.putItem);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final PutItemInput.Builder getPutItem() {
            return this.putItem != null ? this.putItem.toBuilder() : null;
        }

        @Override
        public final Builder putItem(PutItemInput putItem) {
            this.putItem = putItem;
            return this;
        }

        public final void setPutItem(PutItemInput.BuilderImpl putItem) {
            this.putItem = putItem != null ? putItem.build() : null;
        }

        public DynamoDBv2Action build() {
            return new DynamoDBv2Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamoDBv2Action> {
        public Builder roleArn(String var1);

        public Builder putItem(PutItemInput var1);

        default public Builder putItem(Consumer<PutItemInput.Builder> putItem) {
            return this.putItem((PutItemInput)((PutItemInput.Builder)PutItemInput.builder().apply(putItem)).build());
        }
    }
}

