/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TransferData;

@SdkInternalApi
public class TransferDataMarshaller {
    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").build();
    private static final MarshallingInfo<String> REJECTREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectReason").build();
    private static final MarshallingInfo<Date> TRANSFERDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferDate").build();
    private static final MarshallingInfo<Date> ACCEPTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acceptDate").build();
    private static final MarshallingInfo<Date> REJECTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectDate").build();
    private static final TransferDataMarshaller instance = new TransferDataMarshaller();

    public static TransferDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransferData transferData, ProtocolMarshaller protocolMarshaller) {
        if (transferData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transferData.transferMessage(), TRANSFERMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)transferData.rejectReason(), REJECTREASON_BINDING);
            protocolMarshaller.marshall((Object)transferData.transferDate(), TRANSFERDATE_BINDING);
            protocolMarshaller.marshall((Object)transferData.acceptDate(), ACCEPTDATE_BINDING);
            protocolMarshaller.marshall((Object)transferData.rejectDate(), REJECTDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

