/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SalesforceActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SalesforceAction
implements StructuredPojo,
ToCopyableBuilder<Builder, SalesforceAction> {
    private final String token;
    private final String url;

    private SalesforceAction(BuilderImpl builder) {
        this.token = builder.token;
        this.url = builder.url;
    }

    public String token() {
        return this.token;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceAction)) {
            return false;
        }
        SalesforceAction other = (SalesforceAction)obj;
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        if (other.token() != null && !other.token().equals(this.token())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        return other.url() == null || other.url().equals(this.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String token;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceAction model) {
            this.setToken(model.token);
            this.setUrl(model.url);
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public SalesforceAction build() {
            return new SalesforceAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SalesforceAction> {
        public Builder token(String var1);

        public Builder url(String var1);
    }
}

