/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.PolicyVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyVersion> {
    private final String versionId;
    private final Boolean isDefaultVersion;
    private final Date createDate;

    private PolicyVersion(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.createDate = builder.createDate;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Date createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.isDefaultVersion() == null ? 0 : this.isDefaultVersion().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersion)) {
            return false;
        }
        PolicyVersion other = (PolicyVersion)obj;
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.isDefaultVersion() == null ^ this.isDefaultVersion() == null) {
            return false;
        }
        if (other.isDefaultVersion() != null && !other.isDefaultVersion().equals(this.isDefaultVersion())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        return other.createDate() == null || other.createDate().equals(this.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.isDefaultVersion() != null) {
            sb.append("IsDefaultVersion: ").append(this.isDefaultVersion()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String versionId;
        private Boolean isDefaultVersion;
        private Date createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersion model) {
            this.setVersionId(model.versionId);
            this.setIsDefaultVersion(model.isDefaultVersion);
            this.setCreateDate(model.createDate);
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy((Date)createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy((Date)createDate);
        }

        public PolicyVersion build() {
            return new PolicyVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyVersion> {
        public Builder versionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder createDate(Date var1);
    }
}

