/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProcurementPortalPreferenceStatusRequest extends InvoicingRequest implements
        ToCopyableBuilder<UpdateProcurementPortalPreferenceStatusRequest.Builder, UpdateProcurementPortalPreferenceStatusRequest> {
    private static final SdkField<String> PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalPreferenceArn")
            .getter(getter(UpdateProcurementPortalPreferenceStatusRequest::procurementPortalPreferenceArn))
            .setter(setter(Builder::procurementPortalPreferenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreferenceArn")
                    .build()).build();

    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EinvoiceDeliveryPreferenceStatus")
            .getter(getter(UpdateProcurementPortalPreferenceStatusRequest::einvoiceDeliveryPreferenceStatusAsString))
            .setter(setter(Builder::einvoiceDeliveryPreferenceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreferenceStatus")
                    .build()).build();

    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EinvoiceDeliveryPreferenceStatusReason")
            .getter(getter(UpdateProcurementPortalPreferenceStatusRequest::einvoiceDeliveryPreferenceStatusReason))
            .setter(setter(Builder::einvoiceDeliveryPreferenceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EinvoiceDeliveryPreferenceStatusReason").build()).build();

    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseOrderRetrievalPreferenceStatus")
            .getter(getter(UpdateProcurementPortalPreferenceStatusRequest::purchaseOrderRetrievalPreferenceStatusAsString))
            .setter(setter(Builder::purchaseOrderRetrievalPreferenceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PurchaseOrderRetrievalPreferenceStatus").build()).build();

    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseOrderRetrievalPreferenceStatusReason")
            .getter(getter(UpdateProcurementPortalPreferenceStatusRequest::purchaseOrderRetrievalPreferenceStatusReason))
            .setter(setter(Builder::purchaseOrderRetrievalPreferenceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PurchaseOrderRetrievalPreferenceStatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD, EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD,
            EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD, PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD,
            PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String procurementPortalPreferenceArn;

    private final String einvoiceDeliveryPreferenceStatus;

    private final String einvoiceDeliveryPreferenceStatusReason;

    private final String purchaseOrderRetrievalPreferenceStatus;

    private final String purchaseOrderRetrievalPreferenceStatusReason;

    private UpdateProcurementPortalPreferenceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.procurementPortalPreferenceArn = builder.procurementPortalPreferenceArn;
        this.einvoiceDeliveryPreferenceStatus = builder.einvoiceDeliveryPreferenceStatus;
        this.einvoiceDeliveryPreferenceStatusReason = builder.einvoiceDeliveryPreferenceStatusReason;
        this.purchaseOrderRetrievalPreferenceStatus = builder.purchaseOrderRetrievalPreferenceStatus;
        this.purchaseOrderRetrievalPreferenceStatusReason = builder.purchaseOrderRetrievalPreferenceStatusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the procurement portal preference to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the procurement portal preference to update.
     */
    public final String procurementPortalPreferenceArn() {
        return procurementPortalPreferenceArn;
    }

    /**
     * <p>
     * The updated status of the e-invoice delivery preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #einvoiceDeliveryPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #einvoiceDeliveryPreferenceStatusAsString}.
     * </p>
     * 
     * @return The updated status of the e-invoice delivery preference.
     * @see ProcurementPortalPreferenceStatus
     */
    public final ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(einvoiceDeliveryPreferenceStatus);
    }

    /**
     * <p>
     * The updated status of the e-invoice delivery preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #einvoiceDeliveryPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #einvoiceDeliveryPreferenceStatusAsString}.
     * </p>
     * 
     * @return The updated status of the e-invoice delivery preference.
     * @see ProcurementPortalPreferenceStatus
     */
    public final String einvoiceDeliveryPreferenceStatusAsString() {
        return einvoiceDeliveryPreferenceStatus;
    }

    /**
     * <p>
     * The reason for the e-invoice delivery preference status update, providing context for the change.
     * </p>
     * 
     * @return The reason for the e-invoice delivery preference status update, providing context for the change.
     */
    public final String einvoiceDeliveryPreferenceStatusReason() {
        return einvoiceDeliveryPreferenceStatusReason;
    }

    /**
     * <p>
     * The updated status of the purchase order retrieval preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseOrderRetrievalPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #purchaseOrderRetrievalPreferenceStatusAsString}.
     * </p>
     * 
     * @return The updated status of the purchase order retrieval preference.
     * @see ProcurementPortalPreferenceStatus
     */
    public final ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(purchaseOrderRetrievalPreferenceStatus);
    }

    /**
     * <p>
     * The updated status of the purchase order retrieval preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseOrderRetrievalPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #purchaseOrderRetrievalPreferenceStatusAsString}.
     * </p>
     * 
     * @return The updated status of the purchase order retrieval preference.
     * @see ProcurementPortalPreferenceStatus
     */
    public final String purchaseOrderRetrievalPreferenceStatusAsString() {
        return purchaseOrderRetrievalPreferenceStatus;
    }

    /**
     * <p>
     * The reason for the purchase order retrieval preference status update, providing context for the change.
     * </p>
     * 
     * @return The reason for the purchase order retrieval preference status update, providing context for the change.
     */
    public final String purchaseOrderRetrievalPreferenceStatusReason() {
        return purchaseOrderRetrievalPreferenceStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalPreferenceStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProcurementPortalPreferenceStatusRequest)) {
            return false;
        }
        UpdateProcurementPortalPreferenceStatusRequest other = (UpdateProcurementPortalPreferenceStatusRequest) obj;
        return Objects.equals(procurementPortalPreferenceArn(), other.procurementPortalPreferenceArn())
                && Objects.equals(einvoiceDeliveryPreferenceStatusAsString(), other.einvoiceDeliveryPreferenceStatusAsString())
                && Objects.equals(einvoiceDeliveryPreferenceStatusReason(), other.einvoiceDeliveryPreferenceStatusReason())
                && Objects.equals(purchaseOrderRetrievalPreferenceStatusAsString(),
                        other.purchaseOrderRetrievalPreferenceStatusAsString())
                && Objects.equals(purchaseOrderRetrievalPreferenceStatusReason(),
                        other.purchaseOrderRetrievalPreferenceStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProcurementPortalPreferenceStatusRequest")
                .add("ProcurementPortalPreferenceArn", procurementPortalPreferenceArn())
                .add("EinvoiceDeliveryPreferenceStatus", einvoiceDeliveryPreferenceStatusAsString())
                .add("EinvoiceDeliveryPreferenceStatusReason", einvoiceDeliveryPreferenceStatusReason())
                .add("PurchaseOrderRetrievalPreferenceStatus", purchaseOrderRetrievalPreferenceStatusAsString())
                .add("PurchaseOrderRetrievalPreferenceStatusReason", purchaseOrderRetrievalPreferenceStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcurementPortalPreferenceArn":
            return Optional.ofNullable(clazz.cast(procurementPortalPreferenceArn()));
        case "EinvoiceDeliveryPreferenceStatus":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryPreferenceStatusAsString()));
        case "EinvoiceDeliveryPreferenceStatusReason":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryPreferenceStatusReason()));
        case "PurchaseOrderRetrievalPreferenceStatus":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalPreferenceStatusAsString()));
        case "PurchaseOrderRetrievalPreferenceStatusReason":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalPreferenceStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProcurementPortalPreferenceArn", PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatus", EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatusReason", EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatus", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatusReason", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProcurementPortalPreferenceStatusRequest, T> g) {
        return obj -> g.apply((UpdateProcurementPortalPreferenceStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProcurementPortalPreferenceStatusRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the procurement portal preference to update.
         * </p>
         * 
         * @param procurementPortalPreferenceArn
         *        The Amazon Resource Name (ARN) of the procurement portal preference to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn);

        /**
         * <p>
         * The updated status of the e-invoice delivery preference.
         * </p>
         * 
         * @param einvoiceDeliveryPreferenceStatus
         *        The updated status of the e-invoice delivery preference.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder einvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus);

        /**
         * <p>
         * The updated status of the e-invoice delivery preference.
         * </p>
         * 
         * @param einvoiceDeliveryPreferenceStatus
         *        The updated status of the e-invoice delivery preference.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus);

        /**
         * <p>
         * The reason for the e-invoice delivery preference status update, providing context for the change.
         * </p>
         * 
         * @param einvoiceDeliveryPreferenceStatusReason
         *        The reason for the e-invoice delivery preference status update, providing context for the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason);

        /**
         * <p>
         * The updated status of the purchase order retrieval preference.
         * </p>
         * 
         * @param purchaseOrderRetrievalPreferenceStatus
         *        The updated status of the purchase order retrieval preference.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder purchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus);

        /**
         * <p>
         * The updated status of the purchase order retrieval preference.
         * </p>
         * 
         * @param purchaseOrderRetrievalPreferenceStatus
         *        The updated status of the purchase order retrieval preference.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder purchaseOrderRetrievalPreferenceStatus(ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus);

        /**
         * <p>
         * The reason for the purchase order retrieval preference status update, providing context for the change.
         * </p>
         * 
         * @param purchaseOrderRetrievalPreferenceStatusReason
         *        The reason for the purchase order retrieval preference status update, providing context for the
         *        change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private String procurementPortalPreferenceArn;

        private String einvoiceDeliveryPreferenceStatus;

        private String einvoiceDeliveryPreferenceStatusReason;

        private String purchaseOrderRetrievalPreferenceStatus;

        private String purchaseOrderRetrievalPreferenceStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProcurementPortalPreferenceStatusRequest model) {
            super(model);
            procurementPortalPreferenceArn(model.procurementPortalPreferenceArn);
            einvoiceDeliveryPreferenceStatus(model.einvoiceDeliveryPreferenceStatus);
            einvoiceDeliveryPreferenceStatusReason(model.einvoiceDeliveryPreferenceStatusReason);
            purchaseOrderRetrievalPreferenceStatus(model.purchaseOrderRetrievalPreferenceStatus);
            purchaseOrderRetrievalPreferenceStatusReason(model.purchaseOrderRetrievalPreferenceStatusReason);
        }

        public final String getProcurementPortalPreferenceArn() {
            return procurementPortalPreferenceArn;
        }

        public final void setProcurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
        }

        @Override
        public final Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatus() {
            return einvoiceDeliveryPreferenceStatus;
        }

        public final void setEinvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus(einvoiceDeliveryPreferenceStatus == null ? null
                    : einvoiceDeliveryPreferenceStatus.toString());
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatusReason() {
            return einvoiceDeliveryPreferenceStatusReason;
        }

        public final void setEinvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatus() {
            return purchaseOrderRetrievalPreferenceStatus;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
            return this;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(
                ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus(purchaseOrderRetrievalPreferenceStatus == null ? null
                    : purchaseOrderRetrievalPreferenceStatus.toString());
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatusReason() {
            return purchaseOrderRetrievalPreferenceStatusReason;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProcurementPortalPreferenceStatusRequest build() {
            return new UpdateProcurementPortalPreferenceStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
