/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInvoiceUnitRequest extends InvoicingRequest implements
        ToCopyableBuilder<UpdateInvoiceUnitRequest.Builder, UpdateInvoiceUnitRequest> {
    private static final SdkField<String> INVOICE_UNIT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceUnitArn").getter(getter(UpdateInvoiceUnitRequest::invoiceUnitArn))
            .setter(setter(Builder::invoiceUnitArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnitArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateInvoiceUnitRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> TAX_INHERITANCE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TaxInheritanceDisabled").getter(getter(UpdateInvoiceUnitRequest::taxInheritanceDisabled))
            .setter(setter(Builder::taxInheritanceDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxInheritanceDisabled").build())
            .build();

    private static final SdkField<InvoiceUnitRule> RULE_FIELD = SdkField.<InvoiceUnitRule> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(UpdateInvoiceUnitRequest::rule)).setter(setter(Builder::rule))
            .constructor(InvoiceUnitRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNIT_ARN_FIELD,
            DESCRIPTION_FIELD, TAX_INHERITANCE_DISABLED_FIELD, RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invoiceUnitArn;

    private final String description;

    private final Boolean taxInheritanceDisabled;

    private final InvoiceUnitRule rule;

    private UpdateInvoiceUnitRequest(BuilderImpl builder) {
        super(builder);
        this.invoiceUnitArn = builder.invoiceUnitArn;
        this.description = builder.description;
        this.taxInheritanceDisabled = builder.taxInheritanceDisabled;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The ARN to identify an invoice unit. This information can't be modified or deleted.
     * </p>
     * 
     * @return The ARN to identify an invoice unit. This information can't be modified or deleted.
     */
    public final String invoiceUnitArn() {
        return invoiceUnitArn;
    }

    /**
     * <p>
     * The assigned description for an invoice unit. This information can't be modified or deleted.
     * </p>
     * 
     * @return The assigned description for an invoice unit. This information can't be modified or deleted.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     * </p>
     * 
     * @return Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     */
    public final Boolean taxInheritanceDisabled() {
        return taxInheritanceDisabled;
    }

    /**
     * <p>
     * The <code>InvoiceUnitRule</code> object used to update invoice units.
     * </p>
     * 
     * @return The <code>InvoiceUnitRule</code> object used to update invoice units.
     */
    public final InvoiceUnitRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invoiceUnitArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(taxInheritanceDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInvoiceUnitRequest)) {
            return false;
        }
        UpdateInvoiceUnitRequest other = (UpdateInvoiceUnitRequest) obj;
        return Objects.equals(invoiceUnitArn(), other.invoiceUnitArn()) && Objects.equals(description(), other.description())
                && Objects.equals(taxInheritanceDisabled(), other.taxInheritanceDisabled())
                && Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInvoiceUnitRequest").add("InvoiceUnitArn", invoiceUnitArn())
                .add("Description", description()).add("TaxInheritanceDisabled", taxInheritanceDisabled()).add("Rule", rule())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceUnitArn":
            return Optional.ofNullable(clazz.cast(invoiceUnitArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TaxInheritanceDisabled":
            return Optional.ofNullable(clazz.cast(taxInheritanceDisabled()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceUnitArn", INVOICE_UNIT_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TaxInheritanceDisabled", TAX_INHERITANCE_DISABLED_FIELD);
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInvoiceUnitRequest, T> g) {
        return obj -> g.apply((UpdateInvoiceUnitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInvoiceUnitRequest> {
        /**
         * <p>
         * The ARN to identify an invoice unit. This information can't be modified or deleted.
         * </p>
         * 
         * @param invoiceUnitArn
         *        The ARN to identify an invoice unit. This information can't be modified or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnitArn(String invoiceUnitArn);

        /**
         * <p>
         * The assigned description for an invoice unit. This information can't be modified or deleted.
         * </p>
         * 
         * @param description
         *        The assigned description for an invoice unit. This information can't be modified or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * </p>
         * 
         * @param taxInheritanceDisabled
         *        Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled);

        /**
         * <p>
         * The <code>InvoiceUnitRule</code> object used to update invoice units.
         * </p>
         * 
         * @param rule
         *        The <code>InvoiceUnitRule</code> object used to update invoice units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(InvoiceUnitRule rule);

        /**
         * <p>
         * The <code>InvoiceUnitRule</code> object used to update invoice units.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceUnitRule.Builder} avoiding the
         * need to create one manually via {@link InvoiceUnitRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceUnitRule.Builder#build()} is called immediately and its
         * result is passed to {@link #rule(InvoiceUnitRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link InvoiceUnitRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(InvoiceUnitRule)
         */
        default Builder rule(Consumer<InvoiceUnitRule.Builder> rule) {
            return rule(InvoiceUnitRule.builder().applyMutation(rule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private String invoiceUnitArn;

        private String description;

        private Boolean taxInheritanceDisabled;

        private InvoiceUnitRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInvoiceUnitRequest model) {
            super(model);
            invoiceUnitArn(model.invoiceUnitArn);
            description(model.description);
            taxInheritanceDisabled(model.taxInheritanceDisabled);
            rule(model.rule);
        }

        public final String getInvoiceUnitArn() {
            return invoiceUnitArn;
        }

        public final void setInvoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
        }

        @Override
        public final Builder invoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getTaxInheritanceDisabled() {
            return taxInheritanceDisabled;
        }

        public final void setTaxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
        }

        @Override
        public final Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        public final InvoiceUnitRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(InvoiceUnitRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(InvoiceUnitRule rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInvoiceUnitRequest build() {
            return new UpdateInvoiceUnitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
