/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the address associated with the receiver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceiverAddress implements SdkPojo, Serializable, ToCopyableBuilder<ReceiverAddress.Builder, ReceiverAddress> {
    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine1").getter(getter(ReceiverAddress::addressLine1)).setter(setter(Builder::addressLine1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine1").build()).build();

    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine2").getter(getter(ReceiverAddress::addressLine2)).setter(setter(Builder::addressLine2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine2").build()).build();

    private static final SdkField<String> ADDRESS_LINE3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine3").getter(getter(ReceiverAddress::addressLine3)).setter(setter(Builder::addressLine3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine3").build()).build();

    private static final SdkField<String> DISTRICT_OR_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistrictOrCounty").getter(getter(ReceiverAddress::districtOrCounty))
            .setter(setter(Builder::districtOrCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistrictOrCounty").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(ReceiverAddress::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateOrRegion").getter(getter(ReceiverAddress::stateOrRegion)).setter(setter(Builder::stateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrRegion").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(ReceiverAddress::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(ReceiverAddress::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(ReceiverAddress::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LINE1_FIELD,
            ADDRESS_LINE2_FIELD, ADDRESS_LINE3_FIELD, DISTRICT_OR_COUNTY_FIELD, CITY_FIELD, STATE_OR_REGION_FIELD,
            COUNTRY_CODE_FIELD, COMPANY_NAME_FIELD, POSTAL_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addressLine1;

    private final String addressLine2;

    private final String addressLine3;

    private final String districtOrCounty;

    private final String city;

    private final String stateOrRegion;

    private final String countryCode;

    private final String companyName;

    private final String postalCode;

    private ReceiverAddress(BuilderImpl builder) {
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.districtOrCounty = builder.districtOrCounty;
        this.city = builder.city;
        this.stateOrRegion = builder.stateOrRegion;
        this.countryCode = builder.countryCode;
        this.companyName = builder.companyName;
        this.postalCode = builder.postalCode;
    }

    /**
     * <p>
     * The first line of the address.
     * </p>
     * 
     * @return The first line of the address.
     */
    public final String addressLine1() {
        return addressLine1;
    }

    /**
     * <p>
     * The second line of the address, if applicable.
     * </p>
     * 
     * @return The second line of the address, if applicable.
     */
    public final String addressLine2() {
        return addressLine2;
    }

    /**
     * <p>
     * The third line of the address, if applicable.
     * </p>
     * 
     * @return The third line of the address, if applicable.
     */
    public final String addressLine3() {
        return addressLine3;
    }

    /**
     * <p>
     * The district or country the address is located in.
     * </p>
     * 
     * @return The district or country the address is located in.
     */
    public final String districtOrCounty() {
        return districtOrCounty;
    }

    /**
     * <p>
     * The city that the address is in.
     * </p>
     * 
     * @return The city that the address is in.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The state, region, or province the address is located.
     * </p>
     * 
     * @return The state, region, or province the address is located.
     */
    public final String stateOrRegion() {
        return stateOrRegion;
    }

    /**
     * <p>
     * The country code for the country the address is in.
     * </p>
     * 
     * @return The country code for the country the address is in.
     */
    public final String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * A unique company name.
     * </p>
     * 
     * @return A unique company name.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * The postal code associated with the address.
     * </p>
     * 
     * @return The postal code associated with the address.
     */
    public final String postalCode() {
        return postalCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine3());
        hashCode = 31 * hashCode + Objects.hashCode(districtOrCounty());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiverAddress)) {
            return false;
        }
        ReceiverAddress other = (ReceiverAddress) obj;
        return Objects.equals(addressLine1(), other.addressLine1()) && Objects.equals(addressLine2(), other.addressLine2())
                && Objects.equals(addressLine3(), other.addressLine3())
                && Objects.equals(districtOrCounty(), other.districtOrCounty()) && Objects.equals(city(), other.city())
                && Objects.equals(stateOrRegion(), other.stateOrRegion()) && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(postalCode(), other.postalCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReceiverAddress").add("AddressLine1", addressLine1()).add("AddressLine2", addressLine2())
                .add("AddressLine3", addressLine3()).add("DistrictOrCounty", districtOrCounty()).add("City", city())
                .add("StateOrRegion", stateOrRegion()).add("CountryCode", countryCode()).add("CompanyName", companyName())
                .add("PostalCode", postalCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressLine1":
            return Optional.ofNullable(clazz.cast(addressLine1()));
        case "AddressLine2":
            return Optional.ofNullable(clazz.cast(addressLine2()));
        case "AddressLine3":
            return Optional.ofNullable(clazz.cast(addressLine3()));
        case "DistrictOrCounty":
            return Optional.ofNullable(clazz.cast(districtOrCounty()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "StateOrRegion":
            return Optional.ofNullable(clazz.cast(stateOrRegion()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressLine1", ADDRESS_LINE1_FIELD);
        map.put("AddressLine2", ADDRESS_LINE2_FIELD);
        map.put("AddressLine3", ADDRESS_LINE3_FIELD);
        map.put("DistrictOrCounty", DISTRICT_OR_COUNTY_FIELD);
        map.put("City", CITY_FIELD);
        map.put("StateOrRegion", STATE_OR_REGION_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReceiverAddress, T> g) {
        return obj -> g.apply((ReceiverAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReceiverAddress> {
        /**
         * <p>
         * The first line of the address.
         * </p>
         * 
         * @param addressLine1
         *        The first line of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine1(String addressLine1);

        /**
         * <p>
         * The second line of the address, if applicable.
         * </p>
         * 
         * @param addressLine2
         *        The second line of the address, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine2(String addressLine2);

        /**
         * <p>
         * The third line of the address, if applicable.
         * </p>
         * 
         * @param addressLine3
         *        The third line of the address, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine3(String addressLine3);

        /**
         * <p>
         * The district or country the address is located in.
         * </p>
         * 
         * @param districtOrCounty
         *        The district or country the address is located in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder districtOrCounty(String districtOrCounty);

        /**
         * <p>
         * The city that the address is in.
         * </p>
         * 
         * @param city
         *        The city that the address is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state, region, or province the address is located.
         * </p>
         * 
         * @param stateOrRegion
         *        The state, region, or province the address is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrRegion(String stateOrRegion);

        /**
         * <p>
         * The country code for the country the address is in.
         * </p>
         * 
         * @param countryCode
         *        The country code for the country the address is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * A unique company name.
         * </p>
         * 
         * @param companyName
         *        A unique company name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * The postal code associated with the address.
         * </p>
         * 
         * @param postalCode
         *        The postal code associated with the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);
    }

    static final class BuilderImpl implements Builder {
        private String addressLine1;

        private String addressLine2;

        private String addressLine3;

        private String districtOrCounty;

        private String city;

        private String stateOrRegion;

        private String countryCode;

        private String companyName;

        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiverAddress model) {
            addressLine1(model.addressLine1);
            addressLine2(model.addressLine2);
            addressLine3(model.addressLine3);
            districtOrCounty(model.districtOrCounty);
            city(model.city);
            stateOrRegion(model.stateOrRegion);
            countryCode(model.countryCode);
            companyName(model.companyName);
            postalCode(model.postalCode);
        }

        public final String getAddressLine1() {
            return addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getAddressLine3() {
            return addressLine3;
        }

        public final void setAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
        }

        @Override
        public final Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public final String getDistrictOrCounty() {
            return districtOrCounty;
        }

        public final void setDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
        }

        @Override
        public final Builder districtOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getStateOrRegion() {
            return stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Override
        public ReceiverAddress build() {
            return new ReceiverAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
