/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is used to categorize the invoice unit. Values are Amazon Web Services account IDs. Currently, the only
 * supported rule is <code>LINKED_ACCOUNT</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoiceUnitRule implements SdkPojo, Serializable, ToCopyableBuilder<InvoiceUnitRule.Builder, InvoiceUnitRule> {
    private static final SdkField<List<String>> LINKED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkedAccounts")
            .getter(getter(InvoiceUnitRule::linkedAccounts))
            .setter(setter(Builder::linkedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BILL_SOURCE_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BillSourceAccounts")
            .getter(getter(InvoiceUnitRule::billSourceAccounts))
            .setter(setter(Builder::billSourceAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillSourceAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_ACCOUNTS_FIELD,
            BILL_SOURCE_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> linkedAccounts;

    private final List<String> billSourceAccounts;

    private InvoiceUnitRule(BuilderImpl builder) {
        this.linkedAccounts = builder.linkedAccounts;
        this.billSourceAccounts = builder.billSourceAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedAccounts() {
        return linkedAccounts != null && !(linkedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>LINKED_ACCOUNT</code> IDs where charges are included within the invoice unit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedAccounts} method.
     * </p>
     * 
     * @return The list of <code>LINKED_ACCOUNT</code> IDs where charges are included within the invoice unit.
     */
    public final List<String> linkedAccounts() {
        return linkedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the BillSourceAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBillSourceAccounts() {
        return billSourceAccounts != null && !(billSourceAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services account account IDs that have delegated their billing responsibility to the
     * receiver account through transfer billing. Unlike linked accounts, these bill source accounts can be payer
     * accounts from other organizations that have authorized billing transfer to this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillSourceAccounts} method.
     * </p>
     * 
     * @return A list of Amazon Web Services account account IDs that have delegated their billing responsibility to the
     *         receiver account through transfer billing. Unlike linked accounts, these bill source accounts can be
     *         payer accounts from other organizations that have authorized billing transfer to this account.
     */
    public final List<String> billSourceAccounts() {
        return billSourceAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedAccounts() ? linkedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBillSourceAccounts() ? billSourceAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceUnitRule)) {
            return false;
        }
        InvoiceUnitRule other = (InvoiceUnitRule) obj;
        return hasLinkedAccounts() == other.hasLinkedAccounts() && Objects.equals(linkedAccounts(), other.linkedAccounts())
                && hasBillSourceAccounts() == other.hasBillSourceAccounts()
                && Objects.equals(billSourceAccounts(), other.billSourceAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoiceUnitRule").add("LinkedAccounts", hasLinkedAccounts() ? linkedAccounts() : null)
                .add("BillSourceAccounts", hasBillSourceAccounts() ? billSourceAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkedAccounts":
            return Optional.ofNullable(clazz.cast(linkedAccounts()));
        case "BillSourceAccounts":
            return Optional.ofNullable(clazz.cast(billSourceAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LinkedAccounts", LINKED_ACCOUNTS_FIELD);
        map.put("BillSourceAccounts", BILL_SOURCE_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceUnitRule, T> g) {
        return obj -> g.apply((InvoiceUnitRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoiceUnitRule> {
        /**
         * <p>
         * The list of <code>LINKED_ACCOUNT</code> IDs where charges are included within the invoice unit.
         * </p>
         * 
         * @param linkedAccounts
         *        The list of <code>LINKED_ACCOUNT</code> IDs where charges are included within the invoice unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccounts(Collection<String> linkedAccounts);

        /**
         * <p>
         * The list of <code>LINKED_ACCOUNT</code> IDs where charges are included within the invoice unit.
         * </p>
         * 
         * @param linkedAccounts
         *        The list of <code>LINKED_ACCOUNT</code> IDs where charges are included within the invoice unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccounts(String... linkedAccounts);

        /**
         * <p>
         * A list of Amazon Web Services account account IDs that have delegated their billing responsibility to the
         * receiver account through transfer billing. Unlike linked accounts, these bill source accounts can be payer
         * accounts from other organizations that have authorized billing transfer to this account.
         * </p>
         * 
         * @param billSourceAccounts
         *        A list of Amazon Web Services account account IDs that have delegated their billing responsibility to
         *        the receiver account through transfer billing. Unlike linked accounts, these bill source accounts can
         *        be payer accounts from other organizations that have authorized billing transfer to this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billSourceAccounts(Collection<String> billSourceAccounts);

        /**
         * <p>
         * A list of Amazon Web Services account account IDs that have delegated their billing responsibility to the
         * receiver account through transfer billing. Unlike linked accounts, these bill source accounts can be payer
         * accounts from other organizations that have authorized billing transfer to this account.
         * </p>
         * 
         * @param billSourceAccounts
         *        A list of Amazon Web Services account account IDs that have delegated their billing responsibility to
         *        the receiver account through transfer billing. Unlike linked accounts, these bill source accounts can
         *        be payer accounts from other organizations that have authorized billing transfer to this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billSourceAccounts(String... billSourceAccounts);
    }

    static final class BuilderImpl implements Builder {
        private List<String> linkedAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> billSourceAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceUnitRule model) {
            linkedAccounts(model.linkedAccounts);
            billSourceAccounts(model.billSourceAccounts);
        }

        public final Collection<String> getLinkedAccounts() {
            if (linkedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedAccounts;
        }

        public final void setLinkedAccounts(Collection<String> linkedAccounts) {
            this.linkedAccounts = RuleAccountIdListCopier.copy(linkedAccounts);
        }

        @Override
        public final Builder linkedAccounts(Collection<String> linkedAccounts) {
            this.linkedAccounts = RuleAccountIdListCopier.copy(linkedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccounts(String... linkedAccounts) {
            linkedAccounts(Arrays.asList(linkedAccounts));
            return this;
        }

        public final Collection<String> getBillSourceAccounts() {
            if (billSourceAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return billSourceAccounts;
        }

        public final void setBillSourceAccounts(Collection<String> billSourceAccounts) {
            this.billSourceAccounts = RuleAccountIdListCopier.copy(billSourceAccounts);
        }

        @Override
        public final Builder billSourceAccounts(Collection<String> billSourceAccounts) {
            this.billSourceAccounts = RuleAccountIdListCopier.copy(billSourceAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billSourceAccounts(String... billSourceAccounts) {
            billSourceAccounts(Arrays.asList(billSourceAccounts));
            return this;
        }

        @Override
        public InvoiceUnitRule build() {
            return new InvoiceUnitRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
