/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional input to the list API. If multiple filters are specified, the returned list will be a configuration that
 * match all of the provided filters. Supported filter types are <code>InvoiceReceivers</code>, <code>Names</code>, and
 * <code>Accounts</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filters implements SdkPojo, Serializable, ToCopyableBuilder<Filters.Builder, Filters> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Names")
            .getter(getter(Filters::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INVOICE_RECEIVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InvoiceReceivers")
            .getter(getter(Filters::invoiceReceivers))
            .setter(setter(Builder::invoiceReceivers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceReceivers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(Filters::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BILL_SOURCE_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BillSourceAccounts")
            .getter(getter(Filters::billSourceAccounts))
            .setter(setter(Builder::billSourceAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillSourceAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD,
            INVOICE_RECEIVERS_FIELD, ACCOUNTS_FIELD, BILL_SOURCE_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> names;

    private final List<String> invoiceReceivers;

    private final List<String> accounts;

    private final List<String> billSourceAccounts;

    private Filters(BuilderImpl builder) {
        this.names = builder.names;
        this.invoiceReceivers = builder.invoiceReceivers;
        this.accounts = builder.accounts;
        this.billSourceAccounts = builder.billSourceAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Names property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional input to the list API. You can specify a list of invoice unit names inside filters to return invoice
     * units that match only the specified invoice unit names. If multiple names are provided, the result is an
     * <code>OR</code> condition (match any) of the specified invoice unit names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNames} method.
     * </p>
     * 
     * @return An optional input to the list API. You can specify a list of invoice unit names inside filters to return
     *         invoice units that match only the specified invoice unit names. If multiple names are provided, the
     *         result is an <code>OR</code> condition (match any) of the specified invoice unit names.
     */
    public final List<String> names() {
        return names;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvoiceReceivers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvoiceReceivers() {
        return invoiceReceivers != null && !(invoiceReceivers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that match only
     * the specified accounts. If multiple accounts are provided, the result is an <code>OR</code> condition (match any)
     * of the specified accounts. This filter only matches the specified accounts on the invoice receivers of the
     * invoice units.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvoiceReceivers} method.
     * </p>
     * 
     * @return You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that
     *         match only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code>
     *         condition (match any) of the specified accounts. This filter only matches the specified accounts on the
     *         invoice receivers of the invoice units.
     */
    public final List<String> invoiceReceivers() {
        return invoiceReceivers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that match only
     * the specified accounts. If multiple accounts are provided, the result is an <code>OR</code> condition (match any)
     * of the specified accounts. The specified account IDs are matched with either the receiver or the linked accounts
     * in the rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that
     *         match only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code>
     *         condition (match any) of the specified accounts. The specified account IDs are matched with either the
     *         receiver or the linked accounts in the rules.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the BillSourceAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBillSourceAccounts() {
        return billSourceAccounts != null && !(billSourceAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services account account IDs used to filter invoice units. These are payer accounts from
     * other Organizations that have delegated their billing responsibility to the receiver account through the billing
     * transfer feature.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillSourceAccounts} method.
     * </p>
     * 
     * @return A list of Amazon Web Services account account IDs used to filter invoice units. These are payer accounts
     *         from other Organizations that have delegated their billing responsibility to the receiver account through
     *         the billing transfer feature.
     */
    public final List<String> billSourceAccounts() {
        return billSourceAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNames() ? names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInvoiceReceivers() ? invoiceReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBillSourceAccounts() ? billSourceAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters) obj;
        return hasNames() == other.hasNames() && Objects.equals(names(), other.names())
                && hasInvoiceReceivers() == other.hasInvoiceReceivers()
                && Objects.equals(invoiceReceivers(), other.invoiceReceivers()) && hasAccounts() == other.hasAccounts()
                && Objects.equals(accounts(), other.accounts()) && hasBillSourceAccounts() == other.hasBillSourceAccounts()
                && Objects.equals(billSourceAccounts(), other.billSourceAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filters").add("Names", hasNames() ? names() : null)
                .add("InvoiceReceivers", hasInvoiceReceivers() ? invoiceReceivers() : null)
                .add("Accounts", hasAccounts() ? accounts() : null)
                .add("BillSourceAccounts", hasBillSourceAccounts() ? billSourceAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "InvoiceReceivers":
            return Optional.ofNullable(clazz.cast(invoiceReceivers()));
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "BillSourceAccounts":
            return Optional.ofNullable(clazz.cast(billSourceAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Names", NAMES_FIELD);
        map.put("InvoiceReceivers", INVOICE_RECEIVERS_FIELD);
        map.put("Accounts", ACCOUNTS_FIELD);
        map.put("BillSourceAccounts", BILL_SOURCE_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filters> {
        /**
         * <p>
         * An optional input to the list API. You can specify a list of invoice unit names inside filters to return
         * invoice units that match only the specified invoice unit names. If multiple names are provided, the result is
         * an <code>OR</code> condition (match any) of the specified invoice unit names.
         * </p>
         * 
         * @param names
         *        An optional input to the list API. You can specify a list of invoice unit names inside filters to
         *        return invoice units that match only the specified invoice unit names. If multiple names are provided,
         *        the result is an <code>OR</code> condition (match any) of the specified invoice unit names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * An optional input to the list API. You can specify a list of invoice unit names inside filters to return
         * invoice units that match only the specified invoice unit names. If multiple names are provided, the result is
         * an <code>OR</code> condition (match any) of the specified invoice unit names.
         * </p>
         * 
         * @param names
         *        An optional input to the list API. You can specify a list of invoice unit names inside filters to
         *        return invoice units that match only the specified invoice unit names. If multiple names are provided,
         *        the result is an <code>OR</code> condition (match any) of the specified invoice unit names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that match
         * only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code> condition
         * (match any) of the specified accounts. This filter only matches the specified accounts on the invoice
         * receivers of the invoice units.
         * </p>
         * 
         * @param invoiceReceivers
         *        You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that
         *        match only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code>
         *        condition (match any) of the specified accounts. This filter only matches the specified accounts on
         *        the invoice receivers of the invoice units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceReceivers(Collection<String> invoiceReceivers);

        /**
         * <p>
         * You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that match
         * only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code> condition
         * (match any) of the specified accounts. This filter only matches the specified accounts on the invoice
         * receivers of the invoice units.
         * </p>
         * 
         * @param invoiceReceivers
         *        You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that
         *        match only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code>
         *        condition (match any) of the specified accounts. This filter only matches the specified accounts on
         *        the invoice receivers of the invoice units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceReceivers(String... invoiceReceivers);

        /**
         * <p>
         * You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that match
         * only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code> condition
         * (match any) of the specified accounts. The specified account IDs are matched with either the receiver or the
         * linked accounts in the rules.
         * </p>
         * 
         * @param accounts
         *        You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that
         *        match only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code>
         *        condition (match any) of the specified accounts. The specified account IDs are matched with either the
         *        receiver or the linked accounts in the rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that match
         * only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code> condition
         * (match any) of the specified accounts. The specified account IDs are matched with either the receiver or the
         * linked accounts in the rules.
         * </p>
         * 
         * @param accounts
         *        You can specify a list of Amazon Web Services account IDs inside filters to return invoice units that
         *        match only the specified accounts. If multiple accounts are provided, the result is an <code>OR</code>
         *        condition (match any) of the specified accounts. The specified account IDs are matched with either the
         *        receiver or the linked accounts in the rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * A list of Amazon Web Services account account IDs used to filter invoice units. These are payer accounts from
         * other Organizations that have delegated their billing responsibility to the receiver account through the
         * billing transfer feature.
         * </p>
         * 
         * @param billSourceAccounts
         *        A list of Amazon Web Services account account IDs used to filter invoice units. These are payer
         *        accounts from other Organizations that have delegated their billing responsibility to the receiver
         *        account through the billing transfer feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billSourceAccounts(Collection<String> billSourceAccounts);

        /**
         * <p>
         * A list of Amazon Web Services account account IDs used to filter invoice units. These are payer accounts from
         * other Organizations that have delegated their billing responsibility to the receiver account through the
         * billing transfer feature.
         * </p>
         * 
         * @param billSourceAccounts
         *        A list of Amazon Web Services account account IDs used to filter invoice units. These are payer
         *        accounts from other Organizations that have delegated their billing responsibility to the receiver
         *        account through the billing transfer feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billSourceAccounts(String... billSourceAccounts);
    }

    static final class BuilderImpl implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private List<String> invoiceReceivers = DefaultSdkAutoConstructList.getInstance();

        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> billSourceAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            names(model.names);
            invoiceReceivers(model.invoiceReceivers);
            accounts(model.accounts);
            billSourceAccounts(model.billSourceAccounts);
        }

        public final Collection<String> getNames() {
            if (names instanceof SdkAutoConstructList) {
                return null;
            }
            return names;
        }

        public final void setNames(Collection<String> names) {
            this.names = InvoiceUnitNamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = InvoiceUnitNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final Collection<String> getInvoiceReceivers() {
            if (invoiceReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return invoiceReceivers;
        }

        public final void setInvoiceReceivers(Collection<String> invoiceReceivers) {
            this.invoiceReceivers = AccountIdListCopier.copy(invoiceReceivers);
        }

        @Override
        public final Builder invoiceReceivers(Collection<String> invoiceReceivers) {
            this.invoiceReceivers = AccountIdListCopier.copy(invoiceReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceReceivers(String... invoiceReceivers) {
            invoiceReceivers(Arrays.asList(invoiceReceivers));
            return this;
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final Collection<String> getBillSourceAccounts() {
            if (billSourceAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return billSourceAccounts;
        }

        public final void setBillSourceAccounts(Collection<String> billSourceAccounts) {
            this.billSourceAccounts = AccountIdListCopier.copy(billSourceAccounts);
        }

        @Override
        public final Builder billSourceAccounts(Collection<String> billSourceAccounts) {
            this.billSourceAccounts = AccountIdListCopier.copy(billSourceAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billSourceAccounts(String... billSourceAccounts) {
            billSourceAccounts(Arrays.asList(billSourceAccounts));
            return this;
        }

        @Override
        public Filters build() {
            return new Filters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
