/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProcurementPortalPreferenceRequest extends InvoicingRequest implements
        ToCopyableBuilder<CreateProcurementPortalPreferenceRequest.Builder, CreateProcurementPortalPreferenceRequest> {
    private static final SdkField<String> PROCUREMENT_PORTAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalName")
            .getter(getter(CreateProcurementPortalPreferenceRequest::procurementPortalNameAsString))
            .setter(setter(Builder::procurementPortalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalName").build())
            .build();

    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuyerDomain").getter(getter(CreateProcurementPortalPreferenceRequest::buyerDomainAsString))
            .setter(setter(Builder::buyerDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()).build();

    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuyerIdentifier").getter(getter(CreateProcurementPortalPreferenceRequest::buyerIdentifier))
            .setter(setter(Builder::buyerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()).build();

    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplierDomain").getter(getter(CreateProcurementPortalPreferenceRequest::supplierDomainAsString))
            .setter(setter(Builder::supplierDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()).build();

    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplierIdentifier").getter(getter(CreateProcurementPortalPreferenceRequest::supplierIdentifier))
            .setter(setter(Builder::supplierIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build())
            .build();

    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField
            .<ProcurementPortalPreferenceSelector> builder(MarshallingType.SDK_POJO).memberName("Selector")
            .getter(getter(CreateProcurementPortalPreferenceRequest::selector)).setter(setter(Builder::selector))
            .constructor(ProcurementPortalPreferenceSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalSharedSecret")
            .getter(getter(CreateProcurementPortalPreferenceRequest::procurementPortalSharedSecret))
            .setter(setter(Builder::procurementPortalSharedSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret")
                    .build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalInstanceEndpoint")
            .getter(getter(CreateProcurementPortalPreferenceRequest::procurementPortalInstanceEndpoint))
            .setter(setter(Builder::procurementPortalInstanceEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint")
                    .build()).build();

    private static final SdkField<TestEnvPreferenceInput> TEST_ENV_PREFERENCE_FIELD = SdkField
            .<TestEnvPreferenceInput> builder(MarshallingType.SDK_POJO).memberName("TestEnvPreference")
            .getter(getter(CreateProcurementPortalPreferenceRequest::testEnvPreference))
            .setter(setter(Builder::testEnvPreference)).constructor(TestEnvPreferenceInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEnvPreference").build()).build();

    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EinvoiceDeliveryEnabled")
            .getter(getter(CreateProcurementPortalPreferenceRequest::einvoiceDeliveryEnabled))
            .setter(setter(Builder::einvoiceDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build())
            .build();

    private static final SdkField<EinvoiceDeliveryPreference> EINVOICE_DELIVERY_PREFERENCE_FIELD = SdkField
            .<EinvoiceDeliveryPreference> builder(MarshallingType.SDK_POJO)
            .memberName("EinvoiceDeliveryPreference")
            .getter(getter(CreateProcurementPortalPreferenceRequest::einvoiceDeliveryPreference))
            .setter(setter(Builder::einvoiceDeliveryPreference))
            .constructor(EinvoiceDeliveryPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreference").build())
            .build();

    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PurchaseOrderRetrievalEnabled")
            .getter(getter(CreateProcurementPortalPreferenceRequest::purchaseOrderRetrievalEnabled))
            .setter(setter(Builder::purchaseOrderRetrievalEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled")
                    .build()).build();

    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(CreateProcurementPortalPreferenceRequest::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(CreateProcurementPortalPreferenceRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateProcurementPortalPreferenceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCUREMENT_PORTAL_NAME_FIELD,
            BUYER_DOMAIN_FIELD, BUYER_IDENTIFIER_FIELD, SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, SELECTOR_FIELD,
            PROCUREMENT_PORTAL_SHARED_SECRET_FIELD, PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD, TEST_ENV_PREFERENCE_FIELD,
            EINVOICE_DELIVERY_ENABLED_FIELD, EINVOICE_DELIVERY_PREFERENCE_FIELD, PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD,
            CONTACTS_FIELD, RESOURCE_TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String procurementPortalName;

    private final String buyerDomain;

    private final String buyerIdentifier;

    private final String supplierDomain;

    private final String supplierIdentifier;

    private final ProcurementPortalPreferenceSelector selector;

    private final String procurementPortalSharedSecret;

    private final String procurementPortalInstanceEndpoint;

    private final TestEnvPreferenceInput testEnvPreference;

    private final Boolean einvoiceDeliveryEnabled;

    private final EinvoiceDeliveryPreference einvoiceDeliveryPreference;

    private final Boolean purchaseOrderRetrievalEnabled;

    private final List<Contact> contacts;

    private final List<ResourceTag> resourceTags;

    private final String clientToken;

    private CreateProcurementPortalPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.procurementPortalName = builder.procurementPortalName;
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.selector = builder.selector;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
        this.testEnvPreference = builder.testEnvPreference;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.einvoiceDeliveryPreference = builder.einvoiceDeliveryPreference;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.contacts = builder.contacts;
        this.resourceTags = builder.resourceTags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #procurementPortalName} will return {@link ProcurementPortalName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #procurementPortalNameAsString}.
     * </p>
     * 
     * @return The name of the procurement portal.
     * @see ProcurementPortalName
     */
    public final ProcurementPortalName procurementPortalName() {
        return ProcurementPortalName.fromValue(procurementPortalName);
    }

    /**
     * <p>
     * The name of the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #procurementPortalName} will return {@link ProcurementPortalName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #procurementPortalNameAsString}.
     * </p>
     * 
     * @return The name of the procurement portal.
     * @see ProcurementPortalName
     */
    public final String procurementPortalNameAsString() {
        return procurementPortalName;
    }

    /**
     * <p>
     * The domain identifier for the buyer in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buyerDomain} will
     * return {@link BuyerDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buyerDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the buyer in the procurement portal.
     * @see BuyerDomain
     */
    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(buyerDomain);
    }

    /**
     * <p>
     * The domain identifier for the buyer in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buyerDomain} will
     * return {@link BuyerDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buyerDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the buyer in the procurement portal.
     * @see BuyerDomain
     */
    public final String buyerDomainAsString() {
        return buyerDomain;
    }

    /**
     * <p>
     * The unique identifier for the buyer in the procurement portal.
     * </p>
     * 
     * @return The unique identifier for the buyer in the procurement portal.
     */
    public final String buyerIdentifier() {
        return buyerIdentifier;
    }

    /**
     * <p>
     * The domain identifier for the supplier in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supplierDomain}
     * will return {@link SupplierDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #supplierDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the supplier in the procurement portal.
     * @see SupplierDomain
     */
    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(supplierDomain);
    }

    /**
     * <p>
     * The domain identifier for the supplier in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supplierDomain}
     * will return {@link SupplierDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #supplierDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the supplier in the procurement portal.
     * @see SupplierDomain
     */
    public final String supplierDomainAsString() {
        return supplierDomain;
    }

    /**
     * <p>
     * The unique identifier for the supplier in the procurement portal.
     * </p>
     * 
     * @return The unique identifier for the supplier in the procurement portal.
     */
    public final String supplierIdentifier() {
        return supplierIdentifier;
    }

    /**
     * Returns the value of the Selector property for this object.
     * 
     * @return The value of the Selector property for this object.
     */
    public final ProcurementPortalPreferenceSelector selector() {
        return selector;
    }

    /**
     * <p>
     * The shared secret or authentication credential used to establish secure communication with the procurement
     * portal. This value must be encrypted at rest.
     * </p>
     * 
     * @return The shared secret or authentication credential used to establish secure communication with the
     *         procurement portal. This value must be encrypted at rest.
     */
    public final String procurementPortalSharedSecret() {
        return procurementPortalSharedSecret;
    }

    /**
     * <p>
     * The endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid HTTPS URL.
     * </p>
     * 
     * @return The endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid HTTPS URL.
     */
    public final String procurementPortalInstanceEndpoint() {
        return procurementPortalInstanceEndpoint;
    }

    /**
     * <p>
     * Configuration settings for the test environment of the procurement portal. Includes test credentials and
     * endpoints that are used for validation before production deployment.
     * </p>
     * 
     * @return Configuration settings for the test environment of the procurement portal. Includes test credentials and
     *         endpoints that are used for validation before production deployment.
     */
    public final TestEnvPreferenceInput testEnvPreference() {
        return testEnvPreference;
    }

    /**
     * <p>
     * Indicates whether e-invoice delivery is enabled for this procurement portal preference. Set to true to enable
     * e-invoice delivery, false to disable.
     * </p>
     * 
     * @return Indicates whether e-invoice delivery is enabled for this procurement portal preference. Set to true to
     *         enable e-invoice delivery, false to disable.
     */
    public final Boolean einvoiceDeliveryEnabled() {
        return einvoiceDeliveryEnabled;
    }

    /**
     * <p>
     * Specifies the e-invoice delivery configuration including document types, attachment types, and customization
     * settings for the portal.
     * </p>
     * 
     * @return Specifies the e-invoice delivery configuration including document types, attachment types, and
     *         customization settings for the portal.
     */
    public final EinvoiceDeliveryPreference einvoiceDeliveryPreference() {
        return einvoiceDeliveryPreference;
    }

    /**
     * <p>
     * Indicates whether purchase order retrieval is enabled for this procurement portal preference. Set to true to
     * enable PO retrieval, false to disable.
     * </p>
     * 
     * @return Indicates whether purchase order retrieval is enabled for this procurement portal preference. Set to true
     *         to enable PO retrieval, false to disable.
     */
    public final Boolean purchaseOrderRetrievalEnabled() {
        return purchaseOrderRetrievalEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of contact information for portal administrators and technical contacts responsible for the e-invoice
     * integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContacts} method.
     * </p>
     * 
     * @return List of contact information for portal administrators and technical contacts responsible for the
     *         e-invoice integration.
     */
    public final List<Contact> contacts() {
        return contacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to this procurement portal preference resource. Each tag consists of a key and an optional
     * value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return The tags to apply to this procurement portal preference resource. Each tag consists of a key and an
     *         optional value.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalInstanceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(testEnvPreference());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryPreference());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProcurementPortalPreferenceRequest)) {
            return false;
        }
        CreateProcurementPortalPreferenceRequest other = (CreateProcurementPortalPreferenceRequest) obj;
        return Objects.equals(procurementPortalNameAsString(), other.procurementPortalNameAsString())
                && Objects.equals(buyerDomainAsString(), other.buyerDomainAsString())
                && Objects.equals(buyerIdentifier(), other.buyerIdentifier())
                && Objects.equals(supplierDomainAsString(), other.supplierDomainAsString())
                && Objects.equals(supplierIdentifier(), other.supplierIdentifier())
                && Objects.equals(selector(), other.selector())
                && Objects.equals(procurementPortalSharedSecret(), other.procurementPortalSharedSecret())
                && Objects.equals(procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint())
                && Objects.equals(testEnvPreference(), other.testEnvPreference())
                && Objects.equals(einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled())
                && Objects.equals(einvoiceDeliveryPreference(), other.einvoiceDeliveryPreference())
                && Objects.equals(purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled())
                && hasContacts() == other.hasContacts() && Objects.equals(contacts(), other.contacts())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateProcurementPortalPreferenceRequest")
                .add("ProcurementPortalName", procurementPortalNameAsString())
                .add("BuyerDomain", buyerDomainAsString())
                .add("BuyerIdentifier", buyerIdentifier())
                .add("SupplierDomain", supplierDomainAsString())
                .add("SupplierIdentifier", supplierIdentifier())
                .add("Selector", selector())
                .add("ProcurementPortalSharedSecret",
                        procurementPortalSharedSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProcurementPortalInstanceEndpoint", procurementPortalInstanceEndpoint())
                .add("TestEnvPreference", testEnvPreference()).add("EinvoiceDeliveryEnabled", einvoiceDeliveryEnabled())
                .add("EinvoiceDeliveryPreference", einvoiceDeliveryPreference())
                .add("PurchaseOrderRetrievalEnabled", purchaseOrderRetrievalEnabled())
                .add("Contacts", contacts() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcurementPortalName":
            return Optional.ofNullable(clazz.cast(procurementPortalNameAsString()));
        case "BuyerDomain":
            return Optional.ofNullable(clazz.cast(buyerDomainAsString()));
        case "BuyerIdentifier":
            return Optional.ofNullable(clazz.cast(buyerIdentifier()));
        case "SupplierDomain":
            return Optional.ofNullable(clazz.cast(supplierDomainAsString()));
        case "SupplierIdentifier":
            return Optional.ofNullable(clazz.cast(supplierIdentifier()));
        case "Selector":
            return Optional.ofNullable(clazz.cast(selector()));
        case "ProcurementPortalSharedSecret":
            return Optional.ofNullable(clazz.cast(procurementPortalSharedSecret()));
        case "ProcurementPortalInstanceEndpoint":
            return Optional.ofNullable(clazz.cast(procurementPortalInstanceEndpoint()));
        case "TestEnvPreference":
            return Optional.ofNullable(clazz.cast(testEnvPreference()));
        case "EinvoiceDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryEnabled()));
        case "EinvoiceDeliveryPreference":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryPreference()));
        case "PurchaseOrderRetrievalEnabled":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalEnabled()));
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProcurementPortalName", PROCUREMENT_PORTAL_NAME_FIELD);
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        map.put("TestEnvPreference", TEST_ENV_PREFERENCE_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreference", EINVOICE_DELIVERY_PREFERENCE_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProcurementPortalPreferenceRequest, T> g) {
        return obj -> g.apply((CreateProcurementPortalPreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProcurementPortalPreferenceRequest> {
        /**
         * <p>
         * The name of the procurement portal.
         * </p>
         * 
         * @param procurementPortalName
         *        The name of the procurement portal.
         * @see ProcurementPortalName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalName
         */
        Builder procurementPortalName(String procurementPortalName);

        /**
         * <p>
         * The name of the procurement portal.
         * </p>
         * 
         * @param procurementPortalName
         *        The name of the procurement portal.
         * @see ProcurementPortalName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalName
         */
        Builder procurementPortalName(ProcurementPortalName procurementPortalName);

        /**
         * <p>
         * The domain identifier for the buyer in the procurement portal.
         * </p>
         * 
         * @param buyerDomain
         *        The domain identifier for the buyer in the procurement portal.
         * @see BuyerDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuyerDomain
         */
        Builder buyerDomain(String buyerDomain);

        /**
         * <p>
         * The domain identifier for the buyer in the procurement portal.
         * </p>
         * 
         * @param buyerDomain
         *        The domain identifier for the buyer in the procurement portal.
         * @see BuyerDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuyerDomain
         */
        Builder buyerDomain(BuyerDomain buyerDomain);

        /**
         * <p>
         * The unique identifier for the buyer in the procurement portal.
         * </p>
         * 
         * @param buyerIdentifier
         *        The unique identifier for the buyer in the procurement portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buyerIdentifier(String buyerIdentifier);

        /**
         * <p>
         * The domain identifier for the supplier in the procurement portal.
         * </p>
         * 
         * @param supplierDomain
         *        The domain identifier for the supplier in the procurement portal.
         * @see SupplierDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplierDomain
         */
        Builder supplierDomain(String supplierDomain);

        /**
         * <p>
         * The domain identifier for the supplier in the procurement portal.
         * </p>
         * 
         * @param supplierDomain
         *        The domain identifier for the supplier in the procurement portal.
         * @see SupplierDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplierDomain
         */
        Builder supplierDomain(SupplierDomain supplierDomain);

        /**
         * <p>
         * The unique identifier for the supplier in the procurement portal.
         * </p>
         * 
         * @param supplierIdentifier
         *        The unique identifier for the supplier in the procurement portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplierIdentifier(String supplierIdentifier);

        /**
         * Sets the value of the Selector property for this object.
         *
         * @param selector
         *        The new value for the Selector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(ProcurementPortalPreferenceSelector selector);

        /**
         * Sets the value of the Selector property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ProcurementPortalPreferenceSelector.Builder} avoiding the need to create one manually via
         * {@link ProcurementPortalPreferenceSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcurementPortalPreferenceSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #selector(ProcurementPortalPreferenceSelector)}.
         * 
         * @param selector
         *        a consumer that will call methods on {@link ProcurementPortalPreferenceSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selector(ProcurementPortalPreferenceSelector)
         */
        default Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return selector(ProcurementPortalPreferenceSelector.builder().applyMutation(selector).build());
        }

        /**
         * <p>
         * The shared secret or authentication credential used to establish secure communication with the procurement
         * portal. This value must be encrypted at rest.
         * </p>
         * 
         * @param procurementPortalSharedSecret
         *        The shared secret or authentication credential used to establish secure communication with the
         *        procurement portal. This value must be encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalSharedSecret(String procurementPortalSharedSecret);

        /**
         * <p>
         * The endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid HTTPS URL.
         * </p>
         * 
         * @param procurementPortalInstanceEndpoint
         *        The endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid HTTPS
         *        URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint);

        /**
         * <p>
         * Configuration settings for the test environment of the procurement portal. Includes test credentials and
         * endpoints that are used for validation before production deployment.
         * </p>
         * 
         * @param testEnvPreference
         *        Configuration settings for the test environment of the procurement portal. Includes test credentials
         *        and endpoints that are used for validation before production deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testEnvPreference(TestEnvPreferenceInput testEnvPreference);

        /**
         * <p>
         * Configuration settings for the test environment of the procurement portal. Includes test credentials and
         * endpoints that are used for validation before production deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestEnvPreferenceInput.Builder} avoiding
         * the need to create one manually via {@link TestEnvPreferenceInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestEnvPreferenceInput.Builder#build()} is called immediately and
         * its result is passed to {@link #testEnvPreference(TestEnvPreferenceInput)}.
         * 
         * @param testEnvPreference
         *        a consumer that will call methods on {@link TestEnvPreferenceInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testEnvPreference(TestEnvPreferenceInput)
         */
        default Builder testEnvPreference(Consumer<TestEnvPreferenceInput.Builder> testEnvPreference) {
            return testEnvPreference(TestEnvPreferenceInput.builder().applyMutation(testEnvPreference).build());
        }

        /**
         * <p>
         * Indicates whether e-invoice delivery is enabled for this procurement portal preference. Set to true to enable
         * e-invoice delivery, false to disable.
         * </p>
         * 
         * @param einvoiceDeliveryEnabled
         *        Indicates whether e-invoice delivery is enabled for this procurement portal preference. Set to true to
         *        enable e-invoice delivery, false to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled);

        /**
         * <p>
         * Specifies the e-invoice delivery configuration including document types, attachment types, and customization
         * settings for the portal.
         * </p>
         * 
         * @param einvoiceDeliveryPreference
         *        Specifies the e-invoice delivery configuration including document types, attachment types, and
         *        customization settings for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference);

        /**
         * <p>
         * Specifies the e-invoice delivery configuration including document types, attachment types, and customization
         * settings for the portal.
         * </p>
         * This is a convenience method that creates an instance of the {@link EinvoiceDeliveryPreference.Builder}
         * avoiding the need to create one manually via {@link EinvoiceDeliveryPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EinvoiceDeliveryPreference.Builder#build()} is called immediately
         * and its result is passed to {@link #einvoiceDeliveryPreference(EinvoiceDeliveryPreference)}.
         * 
         * @param einvoiceDeliveryPreference
         *        a consumer that will call methods on {@link EinvoiceDeliveryPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #einvoiceDeliveryPreference(EinvoiceDeliveryPreference)
         */
        default Builder einvoiceDeliveryPreference(Consumer<EinvoiceDeliveryPreference.Builder> einvoiceDeliveryPreference) {
            return einvoiceDeliveryPreference(EinvoiceDeliveryPreference.builder().applyMutation(einvoiceDeliveryPreference)
                    .build());
        }

        /**
         * <p>
         * Indicates whether purchase order retrieval is enabled for this procurement portal preference. Set to true to
         * enable PO retrieval, false to disable.
         * </p>
         * 
         * @param purchaseOrderRetrievalEnabled
         *        Indicates whether purchase order retrieval is enabled for this procurement portal preference. Set to
         *        true to enable PO retrieval, false to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled);

        /**
         * <p>
         * List of contact information for portal administrators and technical contacts responsible for the e-invoice
         * integration.
         * </p>
         * 
         * @param contacts
         *        List of contact information for portal administrators and technical contacts responsible for the
         *        e-invoice integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<Contact> contacts);

        /**
         * <p>
         * List of contact information for portal administrators and technical contacts responsible for the e-invoice
         * integration.
         * </p>
         * 
         * @param contacts
         *        List of contact information for portal administrators and technical contacts responsible for the
         *        e-invoice integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Contact... contacts);

        /**
         * <p>
         * List of contact information for portal administrators and technical contacts responsible for the e-invoice
         * integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.Contact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.invoicing.model.Contact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.Contact.Builder#build()} is called immediately and its
         * result is passed to {@link #contacts(List<Contact>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(java.util.Collection<Contact>)
         */
        Builder contacts(Consumer<Contact.Builder>... contacts);

        /**
         * <p>
         * The tags to apply to this procurement portal preference resource. Each tag consists of a key and an optional
         * value.
         * </p>
         * 
         * @param resourceTags
         *        The tags to apply to this procurement portal preference resource. Each tag consists of a key and an
         *        optional value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * The tags to apply to this procurement portal preference resource. Each tag consists of a key and an optional
         * value.
         * </p>
         * 
         * @param resourceTags
         *        The tags to apply to this procurement portal preference resource. Each tag consists of a key and an
         *        optional value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * The tags to apply to this procurement portal preference resource. Each tag consists of a key and an optional
         * value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.invoicing.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.ResourceTag.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private String procurementPortalName;

        private String buyerDomain;

        private String buyerIdentifier;

        private String supplierDomain;

        private String supplierIdentifier;

        private ProcurementPortalPreferenceSelector selector;

        private String procurementPortalSharedSecret;

        private String procurementPortalInstanceEndpoint;

        private TestEnvPreferenceInput testEnvPreference;

        private Boolean einvoiceDeliveryEnabled;

        private EinvoiceDeliveryPreference einvoiceDeliveryPreference;

        private Boolean purchaseOrderRetrievalEnabled;

        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProcurementPortalPreferenceRequest model) {
            super(model);
            procurementPortalName(model.procurementPortalName);
            buyerDomain(model.buyerDomain);
            buyerIdentifier(model.buyerIdentifier);
            supplierDomain(model.supplierDomain);
            supplierIdentifier(model.supplierIdentifier);
            selector(model.selector);
            procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
            testEnvPreference(model.testEnvPreference);
            einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            einvoiceDeliveryPreference(model.einvoiceDeliveryPreference);
            purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            contacts(model.contacts);
            resourceTags(model.resourceTags);
            clientToken(model.clientToken);
        }

        public final String getProcurementPortalName() {
            return procurementPortalName;
        }

        public final void setProcurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
        }

        @Override
        public final Builder procurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
            return this;
        }

        @Override
        public final Builder procurementPortalName(ProcurementPortalName procurementPortalName) {
            this.procurementPortalName(procurementPortalName == null ? null : procurementPortalName.toString());
            return this;
        }

        public final String getBuyerDomain() {
            return buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return selector != null ? selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        public final TestEnvPreferenceInput.Builder getTestEnvPreference() {
            return testEnvPreference != null ? testEnvPreference.toBuilder() : null;
        }

        public final void setTestEnvPreference(TestEnvPreferenceInput.BuilderImpl testEnvPreference) {
            this.testEnvPreference = testEnvPreference != null ? testEnvPreference.build() : null;
        }

        @Override
        public final Builder testEnvPreference(TestEnvPreferenceInput testEnvPreference) {
            this.testEnvPreference = testEnvPreference;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final EinvoiceDeliveryPreference.Builder getEinvoiceDeliveryPreference() {
            return einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.toBuilder() : null;
        }

        public final void setEinvoiceDeliveryPreference(EinvoiceDeliveryPreference.BuilderImpl einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.build() : null;
        }

        @Override
        public final Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> Contact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProcurementPortalPreferenceRequest build() {
            return new CreateProcurementPortalPreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
