/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnitRule;
import software.amazon.awssdk.services.invoicing.model.InvoicingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInvoiceUnitRequest
extends InvoicingRequest
implements ToCopyableBuilder<Builder, UpdateInvoiceUnitRequest> {
    private static final SdkField<String> INVOICE_UNIT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoiceUnitArn").getter(UpdateInvoiceUnitRequest.getter(UpdateInvoiceUnitRequest::invoiceUnitArn)).setter(UpdateInvoiceUnitRequest.setter(Builder::invoiceUnitArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnitArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateInvoiceUnitRequest.getter(UpdateInvoiceUnitRequest::description)).setter(UpdateInvoiceUnitRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> TAX_INHERITANCE_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TaxInheritanceDisabled").getter(UpdateInvoiceUnitRequest.getter(UpdateInvoiceUnitRequest::taxInheritanceDisabled)).setter(UpdateInvoiceUnitRequest.setter(Builder::taxInheritanceDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxInheritanceDisabled").build()}).build();
    private static final SdkField<InvoiceUnitRule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(UpdateInvoiceUnitRequest.getter(UpdateInvoiceUnitRequest::rule)).setter(UpdateInvoiceUnitRequest.setter(Builder::rule)).constructor(InvoiceUnitRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNIT_ARN_FIELD, DESCRIPTION_FIELD, TAX_INHERITANCE_DISABLED_FIELD, RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInvoiceUnitRequest.memberNameToFieldInitializer();
    private final String invoiceUnitArn;
    private final String description;
    private final Boolean taxInheritanceDisabled;
    private final InvoiceUnitRule rule;

    private UpdateInvoiceUnitRequest(BuilderImpl builder) {
        super(builder);
        this.invoiceUnitArn = builder.invoiceUnitArn;
        this.description = builder.description;
        this.taxInheritanceDisabled = builder.taxInheritanceDisabled;
        this.rule = builder.rule;
    }

    public final String invoiceUnitArn() {
        return this.invoiceUnitArn;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean taxInheritanceDisabled() {
        return this.taxInheritanceDisabled;
    }

    public final InvoiceUnitRule rule() {
        return this.rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceUnitArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxInheritanceDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInvoiceUnitRequest)) {
            return false;
        }
        UpdateInvoiceUnitRequest other = (UpdateInvoiceUnitRequest)((Object)obj);
        return Objects.equals(this.invoiceUnitArn(), other.invoiceUnitArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.taxInheritanceDisabled(), other.taxInheritanceDisabled()) && Objects.equals(this.rule(), other.rule());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInvoiceUnitRequest").add("InvoiceUnitArn", (Object)this.invoiceUnitArn()).add("Description", (Object)this.description()).add("TaxInheritanceDisabled", (Object)this.taxInheritanceDisabled()).add("Rule", (Object)this.rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvoiceUnitArn": {
                return Optional.ofNullable(clazz.cast(this.invoiceUnitArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TaxInheritanceDisabled": {
                return Optional.ofNullable(clazz.cast(this.taxInheritanceDisabled()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InvoiceUnitArn", INVOICE_UNIT_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TaxInheritanceDisabled", TAX_INHERITANCE_DISABLED_FIELD);
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInvoiceUnitRequest, T> g) {
        return obj -> g.apply((UpdateInvoiceUnitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InvoicingRequest.BuilderImpl
    implements Builder {
        private String invoiceUnitArn;
        private String description;
        private Boolean taxInheritanceDisabled;
        private InvoiceUnitRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInvoiceUnitRequest model) {
            super(model);
            this.invoiceUnitArn(model.invoiceUnitArn);
            this.description(model.description);
            this.taxInheritanceDisabled(model.taxInheritanceDisabled);
            this.rule(model.rule);
        }

        public final String getInvoiceUnitArn() {
            return this.invoiceUnitArn;
        }

        public final void setInvoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
        }

        @Override
        public final Builder invoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getTaxInheritanceDisabled() {
            return this.taxInheritanceDisabled;
        }

        public final void setTaxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
        }

        @Override
        public final Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        public final InvoiceUnitRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(InvoiceUnitRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(InvoiceUnitRule rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInvoiceUnitRequest build() {
            return new UpdateInvoiceUnitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InvoicingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInvoiceUnitRequest> {
        public Builder invoiceUnitArn(String var1);

        public Builder description(String var1);

        public Builder taxInheritanceDisabled(Boolean var1);

        public Builder rule(InvoiceUnitRule var1);

        default public Builder rule(Consumer<InvoiceUnitRule.Builder> rule) {
            return this.rule((InvoiceUnitRule)((InvoiceUnitRule.Builder)InvoiceUnitRule.builder().applyMutation(rule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

