/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.invoicing.InvoicingClient;
import software.amazon.awssdk.services.invoicing.internal.UserAgentUtils;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnit;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse;

public class ListInvoiceUnitsIterable
implements SdkIterable<ListInvoiceUnitsResponse> {
    private final InvoicingClient client;
    private final ListInvoiceUnitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvoiceUnitsIterable(InvoicingClient client, ListInvoiceUnitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvoiceUnitsResponseFetcher();
    }

    public Iterator<ListInvoiceUnitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvoiceUnit> invoiceUnits() {
        Function<ListInvoiceUnitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invoiceUnits() != null) {
                return response.invoiceUnits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvoiceUnitsResponseFetcher
    implements SyncPageFetcher<ListInvoiceUnitsResponse> {
        private ListInvoiceUnitsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvoiceUnitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvoiceUnitsResponse nextPage(ListInvoiceUnitsResponse previousPage) {
            if (previousPage == null) {
                return ListInvoiceUnitsIterable.this.client.listInvoiceUnits(ListInvoiceUnitsIterable.this.firstRequest);
            }
            return ListInvoiceUnitsIterable.this.client.listInvoiceUnits((ListInvoiceUnitsRequest)((Object)ListInvoiceUnitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

