/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.AccountIdListCopier;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnitNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filters> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(Filters.getter(Filters::names)).setter(Filters.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INVOICE_RECEIVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvoiceReceivers").getter(Filters.getter(Filters::invoiceReceivers)).setter(Filters.setter(Builder::invoiceReceivers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceReceivers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(Filters.getter(Filters::accounts)).setter(Filters.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD, INVOICE_RECEIVERS_FIELD, ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Names", NAMES_FIELD);
            this.put("InvoiceReceivers", INVOICE_RECEIVERS_FIELD);
            this.put("Accounts", ACCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> names;
    private final List<String> invoiceReceivers;
    private final List<String> accounts;

    private Filters(BuilderImpl builder) {
        this.names = builder.names;
        this.invoiceReceivers = builder.invoiceReceivers;
        this.accounts = builder.accounts;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final boolean hasInvoiceReceivers() {
        return this.invoiceReceivers != null && !(this.invoiceReceivers instanceof SdkAutoConstructList);
    }

    public final List<String> invoiceReceivers() {
        return this.invoiceReceivers;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<String> accounts() {
        return this.accounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvoiceReceivers() ? this.invoiceReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && this.hasInvoiceReceivers() == other.hasInvoiceReceivers() && Objects.equals(this.invoiceReceivers(), other.invoiceReceivers()) && this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts());
    }

    public final String toString() {
        return ToString.builder((String)"Filters").add("Names", this.hasNames() ? this.names() : null).add("InvoiceReceivers", this.hasInvoiceReceivers() ? this.invoiceReceivers() : null).add("Accounts", this.hasAccounts() ? this.accounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "InvoiceReceivers": {
                return Optional.ofNullable(clazz.cast(this.invoiceReceivers()));
            }
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private List<String> invoiceReceivers = DefaultSdkAutoConstructList.getInstance();
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            this.names(model.names);
            this.invoiceReceivers(model.invoiceReceivers);
            this.accounts(model.accounts);
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = InvoiceUnitNamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = InvoiceUnitNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final Collection<String> getInvoiceReceivers() {
            if (this.invoiceReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invoiceReceivers;
        }

        public final void setInvoiceReceivers(Collection<String> invoiceReceivers) {
            this.invoiceReceivers = AccountIdListCopier.copy(invoiceReceivers);
        }

        @Override
        public final Builder invoiceReceivers(Collection<String> invoiceReceivers) {
            this.invoiceReceivers = AccountIdListCopier.copy(invoiceReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceReceivers(String ... invoiceReceivers) {
            this.invoiceReceivers(Arrays.asList(invoiceReceivers));
            return this;
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public Filters build() {
            return new Filters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filters> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder invoiceReceivers(Collection<String> var1);

        public Builder invoiceReceivers(String ... var1);

        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);
    }
}

