/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceiverAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReceiverAddress> {
    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressLine1").getter(ReceiverAddress.getter(ReceiverAddress::addressLine1)).setter(ReceiverAddress.setter(Builder::addressLine1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine1").build()}).build();
    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressLine2").getter(ReceiverAddress.getter(ReceiverAddress::addressLine2)).setter(ReceiverAddress.setter(Builder::addressLine2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine2").build()}).build();
    private static final SdkField<String> ADDRESS_LINE3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressLine3").getter(ReceiverAddress.getter(ReceiverAddress::addressLine3)).setter(ReceiverAddress.setter(Builder::addressLine3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine3").build()}).build();
    private static final SdkField<String> DISTRICT_OR_COUNTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistrictOrCounty").getter(ReceiverAddress.getter(ReceiverAddress::districtOrCounty)).setter(ReceiverAddress.setter(Builder::districtOrCounty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistrictOrCounty").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(ReceiverAddress.getter(ReceiverAddress::city)).setter(ReceiverAddress.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateOrRegion").getter(ReceiverAddress.getter(ReceiverAddress::stateOrRegion)).setter(ReceiverAddress.setter(Builder::stateOrRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrRegion").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(ReceiverAddress.getter(ReceiverAddress::countryCode)).setter(ReceiverAddress.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(ReceiverAddress.getter(ReceiverAddress::companyName)).setter(ReceiverAddress.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(ReceiverAddress.getter(ReceiverAddress::postalCode)).setter(ReceiverAddress.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LINE1_FIELD, ADDRESS_LINE2_FIELD, ADDRESS_LINE3_FIELD, DISTRICT_OR_COUNTY_FIELD, CITY_FIELD, STATE_OR_REGION_FIELD, COUNTRY_CODE_FIELD, COMPANY_NAME_FIELD, POSTAL_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AddressLine1", ADDRESS_LINE1_FIELD);
            this.put("AddressLine2", ADDRESS_LINE2_FIELD);
            this.put("AddressLine3", ADDRESS_LINE3_FIELD);
            this.put("DistrictOrCounty", DISTRICT_OR_COUNTY_FIELD);
            this.put("City", CITY_FIELD);
            this.put("StateOrRegion", STATE_OR_REGION_FIELD);
            this.put("CountryCode", COUNTRY_CODE_FIELD);
            this.put("CompanyName", COMPANY_NAME_FIELD);
            this.put("PostalCode", POSTAL_CODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String addressLine1;
    private final String addressLine2;
    private final String addressLine3;
    private final String districtOrCounty;
    private final String city;
    private final String stateOrRegion;
    private final String countryCode;
    private final String companyName;
    private final String postalCode;

    private ReceiverAddress(BuilderImpl builder) {
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.districtOrCounty = builder.districtOrCounty;
        this.city = builder.city;
        this.stateOrRegion = builder.stateOrRegion;
        this.countryCode = builder.countryCode;
        this.companyName = builder.companyName;
        this.postalCode = builder.postalCode;
    }

    public final String addressLine1() {
        return this.addressLine1;
    }

    public final String addressLine2() {
        return this.addressLine2;
    }

    public final String addressLine3() {
        return this.addressLine3;
    }

    public final String districtOrCounty() {
        return this.districtOrCounty;
    }

    public final String city() {
        return this.city;
    }

    public final String stateOrRegion() {
        return this.stateOrRegion;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine3());
        hashCode = 31 * hashCode + Objects.hashCode(this.districtOrCounty());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiverAddress)) {
            return false;
        }
        ReceiverAddress other = (ReceiverAddress)obj;
        return Objects.equals(this.addressLine1(), other.addressLine1()) && Objects.equals(this.addressLine2(), other.addressLine2()) && Objects.equals(this.addressLine3(), other.addressLine3()) && Objects.equals(this.districtOrCounty(), other.districtOrCounty()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.stateOrRegion(), other.stateOrRegion()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.postalCode(), other.postalCode());
    }

    public final String toString() {
        return ToString.builder((String)"ReceiverAddress").add("AddressLine1", (Object)this.addressLine1()).add("AddressLine2", (Object)this.addressLine2()).add("AddressLine3", (Object)this.addressLine3()).add("DistrictOrCounty", (Object)this.districtOrCounty()).add("City", (Object)this.city()).add("StateOrRegion", (Object)this.stateOrRegion()).add("CountryCode", (Object)this.countryCode()).add("CompanyName", (Object)this.companyName()).add("PostalCode", (Object)this.postalCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressLine1": {
                return Optional.ofNullable(clazz.cast(this.addressLine1()));
            }
            case "AddressLine2": {
                return Optional.ofNullable(clazz.cast(this.addressLine2()));
            }
            case "AddressLine3": {
                return Optional.ofNullable(clazz.cast(this.addressLine3()));
            }
            case "DistrictOrCounty": {
                return Optional.ofNullable(clazz.cast(this.districtOrCounty()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "StateOrRegion": {
                return Optional.ofNullable(clazz.cast(this.stateOrRegion()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReceiverAddress, T> g) {
        return obj -> g.apply((ReceiverAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String districtOrCounty;
        private String city;
        private String stateOrRegion;
        private String countryCode;
        private String companyName;
        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiverAddress model) {
            this.addressLine1(model.addressLine1);
            this.addressLine2(model.addressLine2);
            this.addressLine3(model.addressLine3);
            this.districtOrCounty(model.districtOrCounty);
            this.city(model.city);
            this.stateOrRegion(model.stateOrRegion);
            this.countryCode(model.countryCode);
            this.companyName(model.companyName);
            this.postalCode(model.postalCode);
        }

        public final String getAddressLine1() {
            return this.addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return this.addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getAddressLine3() {
            return this.addressLine3;
        }

        public final void setAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
        }

        @Override
        public final Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public final String getDistrictOrCounty() {
            return this.districtOrCounty;
        }

        public final void setDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
        }

        @Override
        public final Builder districtOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getStateOrRegion() {
            return this.stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public ReceiverAddress build() {
            return new ReceiverAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReceiverAddress> {
        public Builder addressLine1(String var1);

        public Builder addressLine2(String var1);

        public Builder addressLine3(String var1);

        public Builder districtOrCounty(String var1);

        public Builder city(String var1);

        public Builder stateOrRegion(String var1);

        public Builder countryCode(String var1);

        public Builder companyName(String var1);

        public Builder postalCode(String var1);
    }
}

