/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An internet service provider (ISP) or network (ASN) in Amazon CloudWatch Internet Monitor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Network implements SdkPojo, Serializable, ToCopyableBuilder<Network.Builder, Network> {
    private static final SdkField<String> AS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ASName")
            .getter(getter(Network::asName)).setter(setter(Builder::asName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASName").build()).build();

    private static final SdkField<Long> AS_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ASNumber")
            .getter(getter(Network::asNumber)).setter(setter(Builder::asNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AS_NAME_FIELD, AS_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String asName;

    private final Long asNumber;

    private Network(BuilderImpl builder) {
        this.asName = builder.asName;
        this.asNumber = builder.asNumber;
    }

    /**
     * <p>
     * The name of the internet service provider (ISP) or network (ASN).
     * </p>
     * 
     * @return The name of the internet service provider (ISP) or network (ASN).
     */
    public final String asName() {
        return asName;
    }

    /**
     * <p>
     * The Autonomous System Number (ASN) of the internet provider or network.
     * </p>
     * 
     * @return The Autonomous System Number (ASN) of the internet provider or network.
     */
    public final Long asNumber() {
        return asNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asName());
        hashCode = 31 * hashCode + Objects.hashCode(asNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network) obj;
        return Objects.equals(asName(), other.asName()) && Objects.equals(asNumber(), other.asNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Network").add("ASName", asName()).add("ASNumber", asNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ASName":
            return Optional.ofNullable(clazz.cast(asName()));
        case "ASNumber":
            return Optional.ofNullable(clazz.cast(asNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ASName", AS_NAME_FIELD);
        map.put("ASNumber", AS_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Network> {
        /**
         * <p>
         * The name of the internet service provider (ISP) or network (ASN).
         * </p>
         * 
         * @param asName
         *        The name of the internet service provider (ISP) or network (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asName(String asName);

        /**
         * <p>
         * The Autonomous System Number (ASN) of the internet provider or network.
         * </p>
         * 
         * @param asNumber
         *        The Autonomous System Number (ASN) of the internet provider or network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asNumber(Long asNumber);
    }

    static final class BuilderImpl implements Builder {
        private String asName;

        private Long asNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            asName(model.asName);
            asNumber(model.asNumber);
        }

        public final String getAsName() {
            return asName;
        }

        public final void setAsName(String asName) {
            this.asName = asName;
        }

        @Override
        public final Builder asName(String asName) {
            this.asName = asName;
            return this;
        }

        public final Long getAsNumber() {
            return asNumber;
        }

        public final void setAsNumber(Long asNumber) {
            this.asNumber = asNumber;
        }

        @Override
        public final Builder asNumber(Long asNumber) {
            this.asNumber = asNumber;
            return this;
        }

        @Override
        public Network build() {
            return new Network(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
