/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCodeSecurityScanConfigurationRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, UpdateCodeSecurityScanConfigurationRequest> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanConfigurationArn").getter(UpdateCodeSecurityScanConfigurationRequest.getter(UpdateCodeSecurityScanConfigurationRequest::scanConfigurationArn)).setter(UpdateCodeSecurityScanConfigurationRequest.setter(Builder::scanConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build()}).build();
    private static final SdkField<CodeSecurityScanConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateCodeSecurityScanConfigurationRequest.getter(UpdateCodeSecurityScanConfigurationRequest::configuration)).setter(UpdateCodeSecurityScanConfigurationRequest.setter(Builder::configuration)).constructor(CodeSecurityScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCodeSecurityScanConfigurationRequest.memberNameToFieldInitializer();
    private final String scanConfigurationArn;
    private final CodeSecurityScanConfiguration configuration;

    private UpdateCodeSecurityScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.configuration = builder.configuration;
    }

    public final String scanConfigurationArn() {
        return this.scanConfigurationArn;
    }

    public final CodeSecurityScanConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCodeSecurityScanConfigurationRequest)) {
            return false;
        }
        UpdateCodeSecurityScanConfigurationRequest other = (UpdateCodeSecurityScanConfigurationRequest)((Object)obj);
        return Objects.equals(this.scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCodeSecurityScanConfigurationRequest").add("ScanConfigurationArn", (Object)this.scanConfigurationArn()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArn()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCodeSecurityScanConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateCodeSecurityScanConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private String scanConfigurationArn;
        private CodeSecurityScanConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCodeSecurityScanConfigurationRequest model) {
            super(model);
            this.scanConfigurationArn(model.scanConfigurationArn);
            this.configuration(model.configuration);
        }

        public final String getScanConfigurationArn() {
            return this.scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final CodeSecurityScanConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CodeSecurityScanConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CodeSecurityScanConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCodeSecurityScanConfigurationRequest build() {
            return new UpdateCodeSecurityScanConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCodeSecurityScanConfigurationRequest> {
        public Builder scanConfigurationArn(String var1);

        public Builder configuration(CodeSecurityScanConfiguration var1);

        default public Builder configuration(Consumer<CodeSecurityScanConfiguration.Builder> configuration) {
            return this.configuration((CodeSecurityScanConfiguration)((CodeSecurityScanConfiguration.Builder)CodeSecurityScanConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

