/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.VulnerabilitiesCopier;
import software.amazon.awssdk.services.inspector2.model.Vulnerability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchVulnerabilitiesResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, SearchVulnerabilitiesResponse> {
    private static final SdkField<List<Vulnerability>> VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vulnerabilities").getter(SearchVulnerabilitiesResponse.getter(SearchVulnerabilitiesResponse::vulnerabilities)).setter(SearchVulnerabilitiesResponse.setter(Builder::vulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Vulnerability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchVulnerabilitiesResponse.getter(SearchVulnerabilitiesResponse::nextToken)).setter(SearchVulnerabilitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VULNERABILITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchVulnerabilitiesResponse.memberNameToFieldInitializer();
    private final List<Vulnerability> vulnerabilities;
    private final String nextToken;

    private SearchVulnerabilitiesResponse(BuilderImpl builder) {
        super(builder);
        this.vulnerabilities = builder.vulnerabilities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVulnerabilities() {
        return this.vulnerabilities != null && !(this.vulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<Vulnerability> vulnerabilities() {
        return this.vulnerabilities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerabilities() ? this.vulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchVulnerabilitiesResponse)) {
            return false;
        }
        SearchVulnerabilitiesResponse other = (SearchVulnerabilitiesResponse)((Object)obj);
        return this.hasVulnerabilities() == other.hasVulnerabilities() && Objects.equals(this.vulnerabilities(), other.vulnerabilities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchVulnerabilitiesResponse").add("Vulnerabilities", this.hasVulnerabilities() ? this.vulnerabilities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilities()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vulnerabilities", VULNERABILITIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchVulnerabilitiesResponse, T> g) {
        return obj -> g.apply((SearchVulnerabilitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<Vulnerability> vulnerabilities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchVulnerabilitiesResponse model) {
            super(model);
            this.vulnerabilities(model.vulnerabilities);
            this.nextToken(model.nextToken);
        }

        public final List<Vulnerability.Builder> getVulnerabilities() {
            List<Vulnerability.Builder> result = VulnerabilitiesCopier.copyToBuilder(this.vulnerabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilities(Collection<Vulnerability.BuilderImpl> vulnerabilities) {
            this.vulnerabilities = VulnerabilitiesCopier.copyFromBuilder(vulnerabilities);
        }

        @Override
        public final Builder vulnerabilities(Collection<Vulnerability> vulnerabilities) {
            this.vulnerabilities = VulnerabilitiesCopier.copy(vulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Vulnerability ... vulnerabilities) {
            this.vulnerabilities(Arrays.asList(vulnerabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Consumer<Vulnerability.Builder> ... vulnerabilities) {
            this.vulnerabilities(Stream.of(vulnerabilities).map(c -> (Vulnerability)((Vulnerability.Builder)Vulnerability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchVulnerabilitiesResponse build() {
            return new SearchVulnerabilitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchVulnerabilitiesResponse> {
        public Builder vulnerabilities(Collection<Vulnerability> var1);

        public Builder vulnerabilities(Vulnerability ... var1);

        public Builder vulnerabilities(Consumer<Vulnerability.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

