/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfigurationSummariesCopier;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfigurationSummary;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodeSecurityScanConfigurationsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCodeSecurityScanConfigurationsResponse> {
    private static final SdkField<List<CodeSecurityScanConfigurationSummary>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurations").getter(ListCodeSecurityScanConfigurationsResponse.getter(ListCodeSecurityScanConfigurationsResponse::configurations)).setter(ListCodeSecurityScanConfigurationsResponse.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeSecurityScanConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCodeSecurityScanConfigurationsResponse.getter(ListCodeSecurityScanConfigurationsResponse::nextToken)).setter(ListCodeSecurityScanConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCodeSecurityScanConfigurationsResponse.memberNameToFieldInitializer();
    private final List<CodeSecurityScanConfigurationSummary> configurations;
    private final String nextToken;

    private ListCodeSecurityScanConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<CodeSecurityScanConfigurationSummary> configurations() {
        return this.configurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSecurityScanConfigurationsResponse)) {
            return false;
        }
        ListCodeSecurityScanConfigurationsResponse other = (ListCodeSecurityScanConfigurationsResponse)((Object)obj);
        return this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCodeSecurityScanConfigurationsResponse").add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configurations", CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSecurityScanConfigurationsResponse, T> g) {
        return obj -> g.apply((ListCodeSecurityScanConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<CodeSecurityScanConfigurationSummary> configurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSecurityScanConfigurationsResponse model) {
            super(model);
            this.configurations(model.configurations);
            this.nextToken(model.nextToken);
        }

        public final List<CodeSecurityScanConfigurationSummary.Builder> getConfigurations() {
            List<CodeSecurityScanConfigurationSummary.Builder> result = CodeSecurityScanConfigurationSummariesCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<CodeSecurityScanConfigurationSummary.BuilderImpl> configurations) {
            this.configurations = CodeSecurityScanConfigurationSummariesCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<CodeSecurityScanConfigurationSummary> configurations) {
            this.configurations = CodeSecurityScanConfigurationSummariesCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(CodeSecurityScanConfigurationSummary ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<CodeSecurityScanConfigurationSummary.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (CodeSecurityScanConfigurationSummary)((CodeSecurityScanConfigurationSummary.Builder)CodeSecurityScanConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCodeSecurityScanConfigurationsResponse build() {
            return new ListCodeSecurityScanConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodeSecurityScanConfigurationsResponse> {
        public Builder configurations(Collection<CodeSecurityScanConfigurationSummary> var1);

        public Builder configurations(CodeSecurityScanConfigurationSummary ... var1);

        public Builder configurations(Consumer<CodeSecurityScanConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

