/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FreeTrialType {
    EC2("EC2"),
    ECR("ECR"),
    LAMBDA("LAMBDA"),
    LAMBDA_CODE("LAMBDA_CODE"),
    CODE_REPOSITORY("CODE_REPOSITORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FreeTrialType> VALUE_MAP;
    private final String value;

    private FreeTrialType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FreeTrialType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FreeTrialType> knownValues() {
        EnumSet<FreeTrialType> knownValues = EnumSet.allOf(FreeTrialType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FreeTrialType.class, FreeTrialType::toString);
    }
}

