/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CisaData;
import software.amazon.awssdk.services.inspector2.model.CwesCopier;
import software.amazon.awssdk.services.inspector2.model.Evidence;
import software.amazon.awssdk.services.inspector2.model.EvidenceListCopier;
import software.amazon.awssdk.services.inspector2.model.ExploitObserved;
import software.amazon.awssdk.services.inspector2.model.ToolsCopier;
import software.amazon.awssdk.services.inspector2.model.TtpsCopier;
import software.amazon.awssdk.services.inspector2.model.VulnerabilityReferenceUrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingDetail> {
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingArn").getter(FindingDetail.getter(FindingDetail::findingArn)).setter(FindingDetail.setter(Builder::findingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()}).build();
    private static final SdkField<CisaData> CISA_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cisaData").getter(FindingDetail.getter(FindingDetail::cisaData)).setter(FindingDetail.setter(Builder::cisaData)).constructor(CisaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cisaData").build()}).build();
    private static final SdkField<Integer> RISK_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("riskScore").getter(FindingDetail.getter(FindingDetail::riskScore)).setter(FindingDetail.setter(Builder::riskScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("riskScore").build()}).build();
    private static final SdkField<List<Evidence>> EVIDENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evidences").getter(FindingDetail.getter(FindingDetail::evidences)).setter(FindingDetail.setter(Builder::evidences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Evidence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TTPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ttps").getter(FindingDetail.getter(FindingDetail::ttps)).setter(FindingDetail.setter(Builder::ttps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(FindingDetail.getter(FindingDetail::tools)).setter(FindingDetail.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExploitObserved> EXPLOIT_OBSERVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exploitObserved").getter(FindingDetail.getter(FindingDetail::exploitObserved)).setter(FindingDetail.setter(Builder::exploitObserved)).constructor(ExploitObserved::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitObserved").build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referenceUrls").getter(FindingDetail.getter(FindingDetail::referenceUrls)).setter(FindingDetail.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CWES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cwes").getter(FindingDetail.getter(FindingDetail::cwes)).setter(FindingDetail.setter(Builder::cwes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cwes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> EPSS_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("epssScore").getter(FindingDetail.getter(FindingDetail::epssScore)).setter(FindingDetail.setter(Builder::epssScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epssScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARN_FIELD, CISA_DATA_FIELD, RISK_SCORE_FIELD, EVIDENCES_FIELD, TTPS_FIELD, TOOLS_FIELD, EXPLOIT_OBSERVED_FIELD, REFERENCE_URLS_FIELD, CWES_FIELD, EPSS_SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String findingArn;
    private final CisaData cisaData;
    private final Integer riskScore;
    private final List<Evidence> evidences;
    private final List<String> ttps;
    private final List<String> tools;
    private final ExploitObserved exploitObserved;
    private final List<String> referenceUrls;
    private final List<String> cwes;
    private final Double epssScore;

    private FindingDetail(BuilderImpl builder) {
        this.findingArn = builder.findingArn;
        this.cisaData = builder.cisaData;
        this.riskScore = builder.riskScore;
        this.evidences = builder.evidences;
        this.ttps = builder.ttps;
        this.tools = builder.tools;
        this.exploitObserved = builder.exploitObserved;
        this.referenceUrls = builder.referenceUrls;
        this.cwes = builder.cwes;
        this.epssScore = builder.epssScore;
    }

    public final String findingArn() {
        return this.findingArn;
    }

    public final CisaData cisaData() {
        return this.cisaData;
    }

    public final Integer riskScore() {
        return this.riskScore;
    }

    public final boolean hasEvidences() {
        return this.evidences != null && !(this.evidences instanceof SdkAutoConstructList);
    }

    public final List<Evidence> evidences() {
        return this.evidences;
    }

    public final boolean hasTtps() {
        return this.ttps != null && !(this.ttps instanceof SdkAutoConstructList);
    }

    public final List<String> ttps() {
        return this.ttps;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<String> tools() {
        return this.tools;
    }

    public final ExploitObserved exploitObserved() {
        return this.exploitObserved;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final boolean hasCwes() {
        return this.cwes != null && !(this.cwes instanceof SdkAutoConstructList);
    }

    public final List<String> cwes() {
        return this.cwes;
    }

    public final Double epssScore() {
        return this.epssScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cisaData());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvidences() ? this.evidences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTtps() ? this.ttps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitObserved());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCwes() ? this.cwes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.epssScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingDetail)) {
            return false;
        }
        FindingDetail other = (FindingDetail)obj;
        return Objects.equals(this.findingArn(), other.findingArn()) && Objects.equals(this.cisaData(), other.cisaData()) && Objects.equals(this.riskScore(), other.riskScore()) && this.hasEvidences() == other.hasEvidences() && Objects.equals(this.evidences(), other.evidences()) && this.hasTtps() == other.hasTtps() && Objects.equals(this.ttps(), other.ttps()) && this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && Objects.equals(this.exploitObserved(), other.exploitObserved()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && this.hasCwes() == other.hasCwes() && Objects.equals(this.cwes(), other.cwes()) && Objects.equals(this.epssScore(), other.epssScore());
    }

    public final String toString() {
        return ToString.builder((String)"FindingDetail").add("FindingArn", (Object)this.findingArn()).add("CisaData", (Object)this.cisaData()).add("RiskScore", (Object)this.riskScore()).add("Evidences", this.hasEvidences() ? this.evidences() : null).add("Ttps", this.hasTtps() ? this.ttps() : null).add("Tools", this.hasTools() ? this.tools() : null).add("ExploitObserved", (Object)this.exploitObserved()).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("Cwes", this.hasCwes() ? this.cwes() : null).add("EpssScore", (Object)this.epssScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingArn": {
                return Optional.ofNullable(clazz.cast(this.findingArn()));
            }
            case "cisaData": {
                return Optional.ofNullable(clazz.cast(this.cisaData()));
            }
            case "riskScore": {
                return Optional.ofNullable(clazz.cast(this.riskScore()));
            }
            case "evidences": {
                return Optional.ofNullable(clazz.cast(this.evidences()));
            }
            case "ttps": {
                return Optional.ofNullable(clazz.cast(this.ttps()));
            }
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "exploitObserved": {
                return Optional.ofNullable(clazz.cast(this.exploitObserved()));
            }
            case "referenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "cwes": {
                return Optional.ofNullable(clazz.cast(this.cwes()));
            }
            case "epssScore": {
                return Optional.ofNullable(clazz.cast(this.epssScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("cisaData", CISA_DATA_FIELD);
        map.put("riskScore", RISK_SCORE_FIELD);
        map.put("evidences", EVIDENCES_FIELD);
        map.put("ttps", TTPS_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("exploitObserved", EXPLOIT_OBSERVED_FIELD);
        map.put("referenceUrls", REFERENCE_URLS_FIELD);
        map.put("cwes", CWES_FIELD);
        map.put("epssScore", EPSS_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingDetail, T> g) {
        return obj -> g.apply((FindingDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingArn;
        private CisaData cisaData;
        private Integer riskScore;
        private List<Evidence> evidences = DefaultSdkAutoConstructList.getInstance();
        private List<String> ttps = DefaultSdkAutoConstructList.getInstance();
        private List<String> tools = DefaultSdkAutoConstructList.getInstance();
        private ExploitObserved exploitObserved;
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();
        private Double epssScore;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingDetail model) {
            this.findingArn(model.findingArn);
            this.cisaData(model.cisaData);
            this.riskScore(model.riskScore);
            this.evidences(model.evidences);
            this.ttps(model.ttps);
            this.tools(model.tools);
            this.exploitObserved(model.exploitObserved);
            this.referenceUrls(model.referenceUrls);
            this.cwes(model.cwes);
            this.epssScore(model.epssScore);
        }

        public final String getFindingArn() {
            return this.findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final CisaData.Builder getCisaData() {
            return this.cisaData != null ? this.cisaData.toBuilder() : null;
        }

        public final void setCisaData(CisaData.BuilderImpl cisaData) {
            this.cisaData = cisaData != null ? cisaData.build() : null;
        }

        @Override
        public final Builder cisaData(CisaData cisaData) {
            this.cisaData = cisaData;
            return this;
        }

        public final Integer getRiskScore() {
            return this.riskScore;
        }

        public final void setRiskScore(Integer riskScore) {
            this.riskScore = riskScore;
        }

        @Override
        public final Builder riskScore(Integer riskScore) {
            this.riskScore = riskScore;
            return this;
        }

        public final List<Evidence.Builder> getEvidences() {
            List<Evidence.Builder> result = EvidenceListCopier.copyToBuilder(this.evidences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvidences(Collection<Evidence.BuilderImpl> evidences) {
            this.evidences = EvidenceListCopier.copyFromBuilder(evidences);
        }

        @Override
        public final Builder evidences(Collection<Evidence> evidences) {
            this.evidences = EvidenceListCopier.copy(evidences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidences(Evidence ... evidences) {
            this.evidences(Arrays.asList(evidences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidences(Consumer<Evidence.Builder> ... evidences) {
            this.evidences(Stream.of(evidences).map(c -> (Evidence)((Evidence.Builder)Evidence.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTtps() {
            if (this.ttps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ttps;
        }

        public final void setTtps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
        }

        @Override
        public final Builder ttps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ttps(String ... ttps) {
            this.ttps(Arrays.asList(ttps));
            return this;
        }

        public final Collection<String> getTools() {
            if (this.tools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tools;
        }

        public final void setTools(Collection<String> tools) {
            this.tools = ToolsCopier.copy(tools);
        }

        @Override
        public final Builder tools(Collection<String> tools) {
            this.tools = ToolsCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(String ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        public final ExploitObserved.Builder getExploitObserved() {
            return this.exploitObserved != null ? this.exploitObserved.toBuilder() : null;
        }

        public final void setExploitObserved(ExploitObserved.BuilderImpl exploitObserved) {
            this.exploitObserved = exploitObserved != null ? exploitObserved.build() : null;
        }

        @Override
        public final Builder exploitObserved(ExploitObserved exploitObserved) {
            this.exploitObserved = exploitObserved;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = VulnerabilityReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = VulnerabilityReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final Collection<String> getCwes() {
            if (this.cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = CwesCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = CwesCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String ... cwes) {
            this.cwes(Arrays.asList(cwes));
            return this;
        }

        public final Double getEpssScore() {
            return this.epssScore;
        }

        public final void setEpssScore(Double epssScore) {
            this.epssScore = epssScore;
        }

        @Override
        public final Builder epssScore(Double epssScore) {
            this.epssScore = epssScore;
            return this;
        }

        public FindingDetail build() {
            return new FindingDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingDetail> {
        public Builder findingArn(String var1);

        public Builder cisaData(CisaData var1);

        default public Builder cisaData(Consumer<CisaData.Builder> cisaData) {
            return this.cisaData((CisaData)((CisaData.Builder)CisaData.builder().applyMutation(cisaData)).build());
        }

        public Builder riskScore(Integer var1);

        public Builder evidences(Collection<Evidence> var1);

        public Builder evidences(Evidence ... var1);

        public Builder evidences(Consumer<Evidence.Builder> ... var1);

        public Builder ttps(Collection<String> var1);

        public Builder ttps(String ... var1);

        public Builder tools(Collection<String> var1);

        public Builder tools(String ... var1);

        public Builder exploitObserved(ExploitObserved var1);

        default public Builder exploitObserved(Consumer<ExploitObserved.Builder> exploitObserved) {
            return this.exploitObserved((ExploitObserved)((ExploitObserved.Builder)ExploitObserved.builder().applyMutation(exploitObserved)).build());
        }

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder cwes(Collection<String> var1);

        public Builder cwes(String ... var1);

        public Builder epssScore(Double var1);
    }
}

