/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Day;
import software.amazon.awssdk.services.inspector2.model.DaysListCopier;
import software.amazon.awssdk.services.inspector2.model.Time;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WeeklySchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WeeklySchedule> {
    private static final SdkField<List<String>> DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("days").getter(WeeklySchedule.getter(WeeklySchedule::daysAsStrings)).setter(WeeklySchedule.setter(Builder::daysWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("days").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Time> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("startTime").getter(WeeklySchedule.getter(WeeklySchedule::startTime)).setter(WeeklySchedule.setter(Builder::startTime)).constructor(Time::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("days", DAYS_FIELD);
            this.put("startTime", START_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> days;
    private final Time startTime;

    private WeeklySchedule(BuilderImpl builder) {
        this.days = builder.days;
        this.startTime = builder.startTime;
    }

    public final List<Day> days() {
        return DaysListCopier.copyStringToEnum(this.days);
    }

    public final boolean hasDays() {
        return this.days != null && !(this.days instanceof SdkAutoConstructList);
    }

    public final List<String> daysAsStrings() {
        return this.days;
    }

    public final Time startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDays() ? this.daysAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklySchedule)) {
            return false;
        }
        WeeklySchedule other = (WeeklySchedule)obj;
        return this.hasDays() == other.hasDays() && Objects.equals(this.daysAsStrings(), other.daysAsStrings()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"WeeklySchedule").add("Days", this.hasDays() ? this.daysAsStrings() : null).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "days": {
                return Optional.ofNullable(clazz.cast(this.daysAsStrings()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WeeklySchedule, T> g) {
        return obj -> g.apply((WeeklySchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> days = DefaultSdkAutoConstructList.getInstance();
        private Time startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklySchedule model) {
            this.daysWithStrings(model.days);
            this.startTime(model.startTime);
        }

        public final Collection<String> getDays() {
            if (this.days instanceof SdkAutoConstructList) {
                return null;
            }
            return this.days;
        }

        public final void setDays(Collection<String> days) {
            this.days = DaysListCopier.copy(days);
        }

        @Override
        public final Builder daysWithStrings(Collection<String> days) {
            this.days = DaysListCopier.copy(days);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysWithStrings(String ... days) {
            this.daysWithStrings(Arrays.asList(days));
            return this;
        }

        @Override
        public final Builder days(Collection<Day> days) {
            this.days = DaysListCopier.copyEnumToString(days);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder days(Day ... days) {
            this.days(Arrays.asList(days));
            return this;
        }

        public final Time.Builder getStartTime() {
            return this.startTime != null ? this.startTime.toBuilder() : null;
        }

        public final void setStartTime(Time.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(Time startTime) {
            this.startTime = startTime;
            return this;
        }

        public WeeklySchedule build() {
            return new WeeklySchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WeeklySchedule> {
        public Builder daysWithStrings(Collection<String> var1);

        public Builder daysWithStrings(String ... var1);

        public Builder days(Collection<Day> var1);

        public Builder days(Day ... var1);

        public Builder startTime(Time var1);

        default public Builder startTime(Consumer<Time.Builder> startTime) {
            return this.startTime((Time)((Time.Builder)Time.builder().applyMutation(startTime)).build());
        }
    }
}

