/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria;
import software.amazon.awssdk.services.inspector2.model.CisScanResultsAggregatedByChecksSortBy;
import software.amazon.awssdk.services.inspector2.model.CisSortOrder;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCisScanResultsAggregatedByChecksRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, ListCisScanResultsAggregatedByChecksRequest> {
    private static final SdkField<CisScanResultsAggregatedByChecksFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(ListCisScanResultsAggregatedByChecksRequest.getter(ListCisScanResultsAggregatedByChecksRequest::filterCriteria)).setter(ListCisScanResultsAggregatedByChecksRequest.setter(Builder::filterCriteria)).constructor(CisScanResultsAggregatedByChecksFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListCisScanResultsAggregatedByChecksRequest.getter(ListCisScanResultsAggregatedByChecksRequest::maxResults)).setter(ListCisScanResultsAggregatedByChecksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCisScanResultsAggregatedByChecksRequest.getter(ListCisScanResultsAggregatedByChecksRequest::nextToken)).setter(ListCisScanResultsAggregatedByChecksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(ListCisScanResultsAggregatedByChecksRequest.getter(ListCisScanResultsAggregatedByChecksRequest::scanArn)).setter(ListCisScanResultsAggregatedByChecksRequest.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ListCisScanResultsAggregatedByChecksRequest.getter(ListCisScanResultsAggregatedByChecksRequest::sortByAsString)).setter(ListCisScanResultsAggregatedByChecksRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListCisScanResultsAggregatedByChecksRequest.getter(ListCisScanResultsAggregatedByChecksRequest::sortOrderAsString)).setter(ListCisScanResultsAggregatedByChecksRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCAN_ARN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("filterCriteria", FILTER_CRITERIA_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("scanArn", SCAN_ARN_FIELD);
            this.put("sortBy", SORT_BY_FIELD);
            this.put("sortOrder", SORT_ORDER_FIELD);
        }
    });
    private final CisScanResultsAggregatedByChecksFilterCriteria filterCriteria;
    private final Integer maxResults;
    private final String nextToken;
    private final String scanArn;
    private final String sortBy;
    private final String sortOrder;

    private ListCisScanResultsAggregatedByChecksRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scanArn = builder.scanArn;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final CisScanResultsAggregatedByChecksFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final CisScanResultsAggregatedByChecksSortBy sortBy() {
        return CisScanResultsAggregatedByChecksSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final CisSortOrder sortOrder() {
        return CisSortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScanResultsAggregatedByChecksRequest)) {
            return false;
        }
        ListCisScanResultsAggregatedByChecksRequest other = (ListCisScanResultsAggregatedByChecksRequest)((Object)obj);
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scanArn(), other.scanArn()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListCisScanResultsAggregatedByChecksRequest").add("FilterCriteria", (Object)this.filterCriteria()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ScanArn", (Object)this.scanArn()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCisScanResultsAggregatedByChecksRequest, T> g) {
        return obj -> g.apply((ListCisScanResultsAggregatedByChecksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private CisScanResultsAggregatedByChecksFilterCriteria filterCriteria;
        private Integer maxResults;
        private String nextToken;
        private String scanArn;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScanResultsAggregatedByChecksRequest model) {
            super(model);
            this.filterCriteria(model.filterCriteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.scanArn(model.scanArn);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final CisScanResultsAggregatedByChecksFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CisScanResultsAggregatedByChecksFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CisScanResultsAggregatedByChecksSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(CisSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCisScanResultsAggregatedByChecksRequest build() {
            return new ListCisScanResultsAggregatedByChecksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCisScanResultsAggregatedByChecksRequest> {
        public Builder filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria var1);

        default public Builder filterCriteria(Consumer<CisScanResultsAggregatedByChecksFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((CisScanResultsAggregatedByChecksFilterCriteria)((CisScanResultsAggregatedByChecksFilterCriteria.Builder)CisScanResultsAggregatedByChecksFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder scanArn(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(CisScanResultsAggregatedByChecksSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(CisSortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

