/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.TargetsCopier;
import software.amazon.awssdk.services.inspector2.model.TtpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AtigData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AtigData> {
    private static final SdkField<Instant> FIRST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstSeen").getter(AtigData.getter(AtigData::firstSeen)).setter(AtigData.setter(Builder::firstSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeen").build()}).build();
    private static final SdkField<Instant> LAST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastSeen").getter(AtigData.getter(AtigData::lastSeen)).setter(AtigData.setter(Builder::lastSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeen").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(AtigData.getter(AtigData::targets)).setter(AtigData.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TTPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ttps").getter(AtigData.getter(AtigData::ttps)).setter(AtigData.setter(Builder::ttps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_SEEN_FIELD, LAST_SEEN_FIELD, TARGETS_FIELD, TTPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("firstSeen", FIRST_SEEN_FIELD);
            this.put("lastSeen", LAST_SEEN_FIELD);
            this.put("targets", TARGETS_FIELD);
            this.put("ttps", TTPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant firstSeen;
    private final Instant lastSeen;
    private final List<String> targets;
    private final List<String> ttps;

    private AtigData(BuilderImpl builder) {
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
        this.targets = builder.targets;
        this.ttps = builder.ttps;
    }

    public final Instant firstSeen() {
        return this.firstSeen;
    }

    public final Instant lastSeen() {
        return this.lastSeen;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final boolean hasTtps() {
        return this.ttps != null && !(this.ttps instanceof SdkAutoConstructList);
    }

    public final List<String> ttps() {
        return this.ttps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTtps() ? this.ttps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtigData)) {
            return false;
        }
        AtigData other = (AtigData)obj;
        return Objects.equals(this.firstSeen(), other.firstSeen()) && Objects.equals(this.lastSeen(), other.lastSeen()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTtps() == other.hasTtps() && Objects.equals(this.ttps(), other.ttps());
    }

    public final String toString() {
        return ToString.builder((String)"AtigData").add("FirstSeen", (Object)this.firstSeen()).add("LastSeen", (Object)this.lastSeen()).add("Targets", this.hasTargets() ? this.targets() : null).add("Ttps", this.hasTtps() ? this.ttps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "firstSeen": {
                return Optional.ofNullable(clazz.cast(this.firstSeen()));
            }
            case "lastSeen": {
                return Optional.ofNullable(clazz.cast(this.lastSeen()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "ttps": {
                return Optional.ofNullable(clazz.cast(this.ttps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AtigData, T> g) {
        return obj -> g.apply((AtigData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant firstSeen;
        private Instant lastSeen;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private List<String> ttps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AtigData model) {
            this.firstSeen(model.firstSeen);
            this.lastSeen(model.lastSeen);
            this.targets(model.targets);
            this.ttps(model.ttps);
        }

        public final Instant getFirstSeen() {
            return this.firstSeen;
        }

        public final void setFirstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final Instant getLastSeen() {
            return this.lastSeen;
        }

        public final void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final Collection<String> getTtps() {
            if (this.ttps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ttps;
        }

        public final void setTtps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
        }

        @Override
        public final Builder ttps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ttps(String ... ttps) {
            this.ttps(Arrays.asList(ttps));
            return this;
        }

        public AtigData build() {
            return new AtigData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AtigData> {
        public Builder firstSeen(Instant var1);

        public Builder lastSeen(Instant var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder ttps(Collection<String> var1);

        public Builder ttps(String ... var1);
    }
}

