/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.PathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEc2DeepInspectionConfigurationResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, UpdateEc2DeepInspectionConfigurationResponse> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(UpdateEc2DeepInspectionConfigurationResponse.getter(UpdateEc2DeepInspectionConfigurationResponse::errorMessage)).setter(UpdateEc2DeepInspectionConfigurationResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<List<String>> ORG_PACKAGE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orgPackagePaths").getter(UpdateEc2DeepInspectionConfigurationResponse.getter(UpdateEc2DeepInspectionConfigurationResponse::orgPackagePaths)).setter(UpdateEc2DeepInspectionConfigurationResponse.setter(Builder::orgPackagePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orgPackagePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PACKAGE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packagePaths").getter(UpdateEc2DeepInspectionConfigurationResponse.getter(UpdateEc2DeepInspectionConfigurationResponse::packagePaths)).setter(UpdateEc2DeepInspectionConfigurationResponse.setter(Builder::packagePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateEc2DeepInspectionConfigurationResponse.getter(UpdateEc2DeepInspectionConfigurationResponse::statusAsString)).setter(UpdateEc2DeepInspectionConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, ORG_PACKAGE_PATHS_FIELD, PACKAGE_PATHS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEc2DeepInspectionConfigurationResponse.memberNameToFieldInitializer();
    private final String errorMessage;
    private final List<String> orgPackagePaths;
    private final List<String> packagePaths;
    private final String status;

    private UpdateEc2DeepInspectionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.orgPackagePaths = builder.orgPackagePaths;
        this.packagePaths = builder.packagePaths;
        this.status = builder.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasOrgPackagePaths() {
        return this.orgPackagePaths != null && !(this.orgPackagePaths instanceof SdkAutoConstructList);
    }

    public final List<String> orgPackagePaths() {
        return this.orgPackagePaths;
    }

    public final boolean hasPackagePaths() {
        return this.packagePaths != null && !(this.packagePaths instanceof SdkAutoConstructList);
    }

    public final List<String> packagePaths() {
        return this.packagePaths;
    }

    public final Ec2DeepInspectionStatus status() {
        return Ec2DeepInspectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrgPackagePaths() ? this.orgPackagePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackagePaths() ? this.packagePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEc2DeepInspectionConfigurationResponse)) {
            return false;
        }
        UpdateEc2DeepInspectionConfigurationResponse other = (UpdateEc2DeepInspectionConfigurationResponse)((Object)obj);
        return Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasOrgPackagePaths() == other.hasOrgPackagePaths() && Objects.equals(this.orgPackagePaths(), other.orgPackagePaths()) && this.hasPackagePaths() == other.hasPackagePaths() && Objects.equals(this.packagePaths(), other.packagePaths()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEc2DeepInspectionConfigurationResponse").add("ErrorMessage", (Object)this.errorMessage()).add("OrgPackagePaths", this.hasOrgPackagePaths() ? this.orgPackagePaths() : null).add("PackagePaths", this.hasPackagePaths() ? this.packagePaths() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "orgPackagePaths": {
                return Optional.ofNullable(clazz.cast(this.orgPackagePaths()));
            }
            case "packagePaths": {
                return Optional.ofNullable(clazz.cast(this.packagePaths()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("orgPackagePaths", ORG_PACKAGE_PATHS_FIELD);
        map.put("packagePaths", PACKAGE_PATHS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEc2DeepInspectionConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateEc2DeepInspectionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String errorMessage;
        private List<String> orgPackagePaths = DefaultSdkAutoConstructList.getInstance();
        private List<String> packagePaths = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEc2DeepInspectionConfigurationResponse model) {
            super(model);
            this.errorMessage(model.errorMessage);
            this.orgPackagePaths(model.orgPackagePaths);
            this.packagePaths(model.packagePaths);
            this.status(model.status);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getOrgPackagePaths() {
            if (this.orgPackagePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.orgPackagePaths;
        }

        public final void setOrgPackagePaths(Collection<String> orgPackagePaths) {
            this.orgPackagePaths = PathListCopier.copy(orgPackagePaths);
        }

        @Override
        public final Builder orgPackagePaths(Collection<String> orgPackagePaths) {
            this.orgPackagePaths = PathListCopier.copy(orgPackagePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orgPackagePaths(String ... orgPackagePaths) {
            this.orgPackagePaths(Arrays.asList(orgPackagePaths));
            return this;
        }

        public final Collection<String> getPackagePaths() {
            if (this.packagePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.packagePaths;
        }

        public final void setPackagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
        }

        @Override
        public final Builder packagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagePaths(String ... packagePaths) {
            this.packagePaths(Arrays.asList(packagePaths));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Ec2DeepInspectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateEc2DeepInspectionConfigurationResponse build() {
            return new UpdateEc2DeepInspectionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEc2DeepInspectionConfigurationResponse> {
        public Builder errorMessage(String var1);

        public Builder orgPackagePaths(Collection<String> var1);

        public Builder orgPackagePaths(String ... var1);

        public Builder packagePaths(Collection<String> var1);

        public Builder packagePaths(String ... var1);

        public Builder status(String var1);

        public Builder status(Ec2DeepInspectionStatus var1);
    }
}

