/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevel;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.Schedule;
import software.amazon.awssdk.services.inspector2.model.UpdateCisTargets;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCisScanConfigurationRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, UpdateCisScanConfigurationRequest> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanConfigurationArn").getter(UpdateCisScanConfigurationRequest.getter(UpdateCisScanConfigurationRequest::scanConfigurationArn)).setter(UpdateCisScanConfigurationRequest.setter(Builder::scanConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build()}).build();
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanName").getter(UpdateCisScanConfigurationRequest.getter(UpdateCisScanConfigurationRequest::scanName)).setter(UpdateCisScanConfigurationRequest.setter(Builder::scanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(UpdateCisScanConfigurationRequest.getter(UpdateCisScanConfigurationRequest::schedule)).setter(UpdateCisScanConfigurationRequest.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityLevel").getter(UpdateCisScanConfigurationRequest.getter(UpdateCisScanConfigurationRequest::securityLevelAsString)).setter(UpdateCisScanConfigurationRequest.setter(Builder::securityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()}).build();
    private static final SdkField<UpdateCisTargets> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targets").getter(UpdateCisScanConfigurationRequest.getter(UpdateCisScanConfigurationRequest::targets)).setter(UpdateCisScanConfigurationRequest.setter(Builder::targets)).constructor(UpdateCisTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD, SCAN_NAME_FIELD, SCHEDULE_FIELD, SECURITY_LEVEL_FIELD, TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCisScanConfigurationRequest.memberNameToFieldInitializer();
    private final String scanConfigurationArn;
    private final String scanName;
    private final Schedule schedule;
    private final String securityLevel;
    private final UpdateCisTargets targets;

    private UpdateCisScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.scanName = builder.scanName;
        this.schedule = builder.schedule;
        this.securityLevel = builder.securityLevel;
        this.targets = builder.targets;
    }

    public final String scanConfigurationArn() {
        return this.scanConfigurationArn;
    }

    public final String scanName() {
        return this.scanName;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(this.securityLevel);
    }

    public final String securityLevelAsString() {
        return this.securityLevel;
    }

    public final UpdateCisTargets targets() {
        return this.targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCisScanConfigurationRequest)) {
            return false;
        }
        UpdateCisScanConfigurationRequest other = (UpdateCisScanConfigurationRequest)((Object)obj);
        return Objects.equals(this.scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(this.scanName(), other.scanName()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.securityLevelAsString(), other.securityLevelAsString()) && Objects.equals(this.targets(), other.targets());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCisScanConfigurationRequest").add("ScanConfigurationArn", (Object)this.scanConfigurationArn()).add("ScanName", (Object)this.scanName()).add("Schedule", (Object)this.schedule()).add("SecurityLevel", (Object)this.securityLevelAsString()).add("Targets", (Object)this.targets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArn()));
            }
            case "scanName": {
                return Optional.ofNullable(clazz.cast(this.scanName()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "securityLevel": {
                return Optional.ofNullable(clazz.cast(this.securityLevelAsString()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("securityLevel", SECURITY_LEVEL_FIELD);
        map.put("targets", TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCisScanConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateCisScanConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private String scanConfigurationArn;
        private String scanName;
        private Schedule schedule;
        private String securityLevel;
        private UpdateCisTargets targets;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCisScanConfigurationRequest model) {
            super(model);
            this.scanConfigurationArn(model.scanConfigurationArn);
            this.scanName(model.scanName);
            this.schedule(model.schedule);
            this.securityLevel(model.securityLevel);
            this.targets(model.targets);
        }

        public final String getScanConfigurationArn() {
            return this.scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getScanName() {
            return this.scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSecurityLevel() {
            return this.securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        public final UpdateCisTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        public final void setTargets(UpdateCisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(UpdateCisTargets targets) {
            this.targets = targets;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCisScanConfigurationRequest build() {
            return new UpdateCisScanConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCisScanConfigurationRequest> {
        public Builder scanConfigurationArn(String var1);

        public Builder scanName(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder securityLevel(String var1);

        public Builder securityLevel(CisSecurityLevel var1);

        public Builder targets(UpdateCisTargets var1);

        default public Builder targets(Consumer<UpdateCisTargets.Builder> targets) {
            return this.targets((UpdateCisTargets)((UpdateCisTargets.Builder)UpdateCisTargets.builder().applyMutation(targets)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

