/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.AssessmentTarget;
import software.amazon.awssdk.services.inspector.model.AssessmentTargetListCopier;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssessmentTargetsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeAssessmentTargetsResponse> {
    private static final SdkField<List<AssessmentTarget>> ASSESSMENT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTargets").getter(DescribeAssessmentTargetsResponse.getter(DescribeAssessmentTargetsResponse::assessmentTargets)).setter(DescribeAssessmentTargetsResponse.setter(Builder::assessmentTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedItems").getter(DescribeAssessmentTargetsResponse.getter(DescribeAssessmentTargetsResponse::failedItems)).setter(DescribeAssessmentTargetsResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGETS_FIELD, FAILED_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAssessmentTargetsResponse.memberNameToFieldInitializer();
    private final List<AssessmentTarget> assessmentTargets;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeAssessmentTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargets = builder.assessmentTargets;
        this.failedItems = builder.failedItems;
    }

    public final boolean hasAssessmentTargets() {
        return this.assessmentTargets != null && !(this.assessmentTargets instanceof SdkAutoConstructList);
    }

    public final List<AssessmentTarget> assessmentTargets() {
        return this.assessmentTargets;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTargets() ? this.assessmentTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTargetsResponse)) {
            return false;
        }
        DescribeAssessmentTargetsResponse other = (DescribeAssessmentTargetsResponse)((Object)obj);
        return this.hasAssessmentTargets() == other.hasAssessmentTargets() && Objects.equals(this.assessmentTargets(), other.assessmentTargets()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssessmentTargetsResponse").add("AssessmentTargets", this.hasAssessmentTargets() ? this.assessmentTargets() : null).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargets": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargets()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assessmentTargets", ASSESSMENT_TARGETS_FIELD);
        map.put("failedItems", FAILED_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentTargetsResponse, T> g) {
        return obj -> g.apply((DescribeAssessmentTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<AssessmentTarget> assessmentTargets = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentTargetsResponse model) {
            super(model);
            this.assessmentTargets(model.assessmentTargets);
            this.failedItems(model.failedItems);
        }

        public final List<AssessmentTarget.Builder> getAssessmentTargets() {
            List<AssessmentTarget.Builder> result = AssessmentTargetListCopier.copyToBuilder(this.assessmentTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentTargets(Collection<AssessmentTarget.BuilderImpl> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetListCopier.copyFromBuilder(assessmentTargets);
        }

        @Override
        public final Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetListCopier.copy(assessmentTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(AssessmentTarget ... assessmentTargets) {
            this.assessmentTargets(Arrays.asList(assessmentTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(Consumer<AssessmentTarget.Builder> ... assessmentTargets) {
            this.assessmentTargets(Stream.of(assessmentTargets).map(c -> (AssessmentTarget)((AssessmentTarget.Builder)AssessmentTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            Map<String, FailedItemDetails.Builder> result = FailedItemsCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        @Override
        public DescribeAssessmentTargetsResponse build() {
            return new DescribeAssessmentTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssessmentTargetsResponse> {
        public Builder assessmentTargets(Collection<AssessmentTarget> var1);

        public Builder assessmentTargets(AssessmentTarget ... var1);

        public Builder assessmentTargets(Consumer<AssessmentTarget.Builder> ... var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

