/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse;

public class GetExclusionsPreviewIterable
implements SdkIterable<GetExclusionsPreviewResponse> {
    private final InspectorClient client;
    private final GetExclusionsPreviewRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetExclusionsPreviewIterable(InspectorClient client, GetExclusionsPreviewRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetExclusionsPreviewResponseFetcher();
    }

    public Iterator<GetExclusionsPreviewResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetExclusionsPreviewResponseFetcher
    implements SyncPageFetcher<GetExclusionsPreviewResponse> {
        private GetExclusionsPreviewResponseFetcher() {
        }

        public boolean hasNextPage(GetExclusionsPreviewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetExclusionsPreviewResponse nextPage(GetExclusionsPreviewResponse previousPage) {
            if (previousPage == null) {
                return GetExclusionsPreviewIterable.this.client.getExclusionsPreview(GetExclusionsPreviewIterable.this.firstRequest);
            }
            return GetExclusionsPreviewIterable.this.client.getExclusionsPreview((GetExclusionsPreviewRequest)((Object)GetExclusionsPreviewIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

