/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssetAttributes;
import software.amazon.awssdk.services.inspector.model.AssetType;
import software.amazon.awssdk.services.inspector.model.Attribute;
import software.amazon.awssdk.services.inspector.model.AttributeListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorServiceAttributes;
import software.amazon.awssdk.services.inspector.model.Severity;
import software.amazon.awssdk.services.inspector.model.UserAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Finding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Finding> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Finding.getter(Finding::arn)).setter(Finding.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schemaVersion").getter(Finding.getter(Finding::schemaVersion)).setter(Finding.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(Finding.getter(Finding::service)).setter(Finding.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<InspectorServiceAttributes> SERVICE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceAttributes").getter(Finding.getter(Finding::serviceAttributes)).setter(Finding.setter(Builder::serviceAttributes)).constructor(InspectorServiceAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAttributes").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetType").getter(Finding.getter(Finding::assetTypeAsString)).setter(Finding.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetType").build()}).build();
    private static final SdkField<AssetAttributes> ASSET_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetAttributes").getter(Finding.getter(Finding::assetAttributes)).setter(Finding.setter(Builder::assetAttributes)).constructor(AssetAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetAttributes").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Finding.getter(Finding::id)).setter(Finding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Finding.getter(Finding::title)).setter(Finding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Finding.getter(Finding::description)).setter(Finding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendation").getter(Finding.getter(Finding::recommendation)).setter(Finding.setter(Builder::recommendation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(Finding.getter(Finding::severityAsString)).setter(Finding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Double> NUMERIC_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("numericSeverity").getter(Finding.getter(Finding::numericSeverity)).setter(Finding.setter(Builder::numericSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numericSeverity").build()}).build();
    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("confidence").getter(Finding.getter(Finding::confidence)).setter(Finding.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()}).build();
    private static final SdkField<Boolean> INDICATOR_OF_COMPROMISE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("indicatorOfCompromise").getter(Finding.getter(Finding::indicatorOfCompromise)).setter(Finding.setter(Builder::indicatorOfCompromise)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indicatorOfCompromise").build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(Finding.getter(Finding::attributes)).setter(Finding.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAttributes").getter(Finding.getter(Finding::userAttributes)).setter(Finding.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Finding.getter(Finding::createdAt)).setter(Finding.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Finding.getter(Finding::updatedAt)).setter(Finding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SCHEMA_VERSION_FIELD, SERVICE_FIELD, SERVICE_ATTRIBUTES_FIELD, ASSET_TYPE_FIELD, ASSET_ATTRIBUTES_FIELD, ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, RECOMMENDATION_FIELD, SEVERITY_FIELD, NUMERIC_SEVERITY_FIELD, CONFIDENCE_FIELD, INDICATOR_OF_COMPROMISE_FIELD, ATTRIBUTES_FIELD, USER_ATTRIBUTES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Integer schemaVersion;
    private final String service;
    private final InspectorServiceAttributes serviceAttributes;
    private final String assetType;
    private final AssetAttributes assetAttributes;
    private final String id;
    private final String title;
    private final String description;
    private final String recommendation;
    private final String severity;
    private final Double numericSeverity;
    private final Integer confidence;
    private final Boolean indicatorOfCompromise;
    private final List<Attribute> attributes;
    private final List<Attribute> userAttributes;
    private final Instant createdAt;
    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.arn = builder.arn;
        this.schemaVersion = builder.schemaVersion;
        this.service = builder.service;
        this.serviceAttributes = builder.serviceAttributes;
        this.assetType = builder.assetType;
        this.assetAttributes = builder.assetAttributes;
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.recommendation = builder.recommendation;
        this.severity = builder.severity;
        this.numericSeverity = builder.numericSeverity;
        this.confidence = builder.confidence;
        this.indicatorOfCompromise = builder.indicatorOfCompromise;
        this.attributes = builder.attributes;
        this.userAttributes = builder.userAttributes;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer schemaVersion() {
        return this.schemaVersion;
    }

    public final String service() {
        return this.service;
    }

    public final InspectorServiceAttributes serviceAttributes() {
        return this.serviceAttributes;
    }

    public final AssetType assetType() {
        return AssetType.fromValue(this.assetType);
    }

    public final String assetTypeAsString() {
        return this.assetType;
    }

    public final AssetAttributes assetAttributes() {
        return this.assetAttributes;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String recommendation() {
        return this.recommendation;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final Double numericSeverity() {
        return this.numericSeverity;
    }

    public final Integer confidence() {
        return this.confidence;
    }

    public final Boolean indicatorOfCompromise() {
        return this.indicatorOfCompromise;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    public final boolean hasUserAttributes() {
        return this.userAttributes != null && !(this.userAttributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> userAttributes() {
        return this.userAttributes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.indicatorOfCompromise());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributes() ? this.userAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.serviceAttributes(), other.serviceAttributes()) && Objects.equals(this.assetTypeAsString(), other.assetTypeAsString()) && Objects.equals(this.assetAttributes(), other.assetAttributes()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.numericSeverity(), other.numericSeverity()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.indicatorOfCompromise(), other.indicatorOfCompromise()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasUserAttributes() == other.hasUserAttributes() && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Finding").add("Arn", (Object)this.arn()).add("SchemaVersion", (Object)this.schemaVersion()).add("Service", (Object)this.service()).add("ServiceAttributes", (Object)this.serviceAttributes()).add("AssetType", (Object)this.assetTypeAsString()).add("AssetAttributes", (Object)this.assetAttributes()).add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Recommendation", (Object)this.recommendation()).add("Severity", (Object)this.severityAsString()).add("NumericSeverity", (Object)this.numericSeverity()).add("Confidence", (Object)this.confidence()).add("IndicatorOfCompromise", (Object)this.indicatorOfCompromise()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("UserAttributes", this.hasUserAttributes() ? this.userAttributes() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "serviceAttributes": {
                return Optional.ofNullable(clazz.cast(this.serviceAttributes()));
            }
            case "assetType": {
                return Optional.ofNullable(clazz.cast(this.assetTypeAsString()));
            }
            case "assetAttributes": {
                return Optional.ofNullable(clazz.cast(this.assetAttributes()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "numericSeverity": {
                return Optional.ofNullable(clazz.cast(this.numericSeverity()));
            }
            case "confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "indicatorOfCompromise": {
                return Optional.ofNullable(clazz.cast(this.indicatorOfCompromise()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "userAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Integer schemaVersion;
        private String service;
        private InspectorServiceAttributes serviceAttributes;
        private String assetType;
        private AssetAttributes assetAttributes;
        private String id;
        private String title;
        private String description;
        private String recommendation;
        private String severity;
        private Double numericSeverity;
        private Integer confidence;
        private Boolean indicatorOfCompromise;
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.arn(model.arn);
            this.schemaVersion(model.schemaVersion);
            this.service(model.service);
            this.serviceAttributes(model.serviceAttributes);
            this.assetType(model.assetType);
            this.assetAttributes(model.assetAttributes);
            this.id(model.id);
            this.title(model.title);
            this.description(model.description);
            this.recommendation(model.recommendation);
            this.severity(model.severity);
            this.numericSeverity(model.numericSeverity);
            this.confidence(model.confidence);
            this.indicatorOfCompromise(model.indicatorOfCompromise);
            this.attributes(model.attributes);
            this.userAttributes(model.userAttributes);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final InspectorServiceAttributes.Builder getServiceAttributes() {
            return this.serviceAttributes != null ? this.serviceAttributes.toBuilder() : null;
        }

        @Override
        public final Builder serviceAttributes(InspectorServiceAttributes serviceAttributes) {
            this.serviceAttributes = serviceAttributes;
            return this;
        }

        public final void setServiceAttributes(InspectorServiceAttributes.BuilderImpl serviceAttributes) {
            this.serviceAttributes = serviceAttributes != null ? serviceAttributes.build() : null;
        }

        public final String getAssetType() {
            return this.assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        public final AssetAttributes.Builder getAssetAttributes() {
            return this.assetAttributes != null ? this.assetAttributes.toBuilder() : null;
        }

        @Override
        public final Builder assetAttributes(AssetAttributes assetAttributes) {
            this.assetAttributes = assetAttributes;
            return this;
        }

        public final void setAssetAttributes(AssetAttributes.BuilderImpl assetAttributes) {
            this.assetAttributes = assetAttributes != null ? assetAttributes.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRecommendation() {
            return this.recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Double getNumericSeverity() {
            return this.numericSeverity;
        }

        @Override
        public final Builder numericSeverity(Double numericSeverity) {
            this.numericSeverity = numericSeverity;
            return this;
        }

        public final void setNumericSeverity(Double numericSeverity) {
            this.numericSeverity = numericSeverity;
        }

        public final Integer getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        public final Boolean getIndicatorOfCompromise() {
            return this.indicatorOfCompromise;
        }

        @Override
        public final Builder indicatorOfCompromise(Boolean indicatorOfCompromise) {
            this.indicatorOfCompromise = indicatorOfCompromise;
            return this;
        }

        public final void setIndicatorOfCompromise(Boolean indicatorOfCompromise) {
            this.indicatorOfCompromise = indicatorOfCompromise;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        public final List<Attribute.Builder> getUserAttributes() {
            List<Attribute.Builder> result = UserAttributeListCopier.copyToBuilder(this.userAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userAttributes(Collection<Attribute> userAttributes) {
            this.userAttributes = UserAttributeListCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Attribute ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<Attribute.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<Attribute.BuilderImpl> userAttributes) {
            this.userAttributes = UserAttributeListCopier.copyFromBuilder(userAttributes);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Finding build() {
            return new Finding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Finding> {
        public Builder arn(String var1);

        public Builder schemaVersion(Integer var1);

        public Builder service(String var1);

        public Builder serviceAttributes(InspectorServiceAttributes var1);

        default public Builder serviceAttributes(Consumer<InspectorServiceAttributes.Builder> serviceAttributes) {
            return this.serviceAttributes((InspectorServiceAttributes)((InspectorServiceAttributes.Builder)InspectorServiceAttributes.builder().applyMutation(serviceAttributes)).build());
        }

        public Builder assetType(String var1);

        public Builder assetType(AssetType var1);

        public Builder assetAttributes(AssetAttributes var1);

        default public Builder assetAttributes(Consumer<AssetAttributes.Builder> assetAttributes) {
            return this.assetAttributes((AssetAttributes)((AssetAttributes.Builder)AssetAttributes.builder().applyMutation(assetAttributes)).build());
        }

        public Builder id(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder recommendation(String var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder numericSeverity(Double var1);

        public Builder confidence(Integer var1);

        public Builder indicatorOfCompromise(Boolean var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder userAttributes(Collection<Attribute> var1);

        public Builder userAttributes(Attribute ... var1);

        public Builder userAttributes(Consumer<Attribute.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

