/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AddRemoveAttributesFindingArnListCopier;
import software.amazon.awssdk.services.inspector.model.Attribute;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.UserAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddAttributesToFindingsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, AddAttributesToFindingsRequest> {
    private static final SdkField<List<String>> FINDING_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingArns").getter(AddAttributesToFindingsRequest.getter(AddAttributesToFindingsRequest::findingArns)).setter(AddAttributesToFindingsRequest.setter(Builder::findingArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(AddAttributesToFindingsRequest.getter(AddAttributesToFindingsRequest::attributes)).setter(AddAttributesToFindingsRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARNS_FIELD, ATTRIBUTES_FIELD));
    private final List<String> findingArns;
    private final List<Attribute> attributes;

    private AddAttributesToFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingArns = builder.findingArns;
        this.attributes = builder.attributes;
    }

    public final boolean hasFindingArns() {
        return this.findingArns != null && !(this.findingArns instanceof SdkAutoConstructList);
    }

    public final List<String> findingArns() {
        return this.findingArns;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingArns() ? this.findingArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttributesToFindingsRequest)) {
            return false;
        }
        AddAttributesToFindingsRequest other = (AddAttributesToFindingsRequest)((Object)obj);
        return this.hasFindingArns() == other.hasFindingArns() && Objects.equals(this.findingArns(), other.findingArns()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"AddAttributesToFindingsRequest").add("FindingArns", this.hasFindingArns() ? this.findingArns() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingArns": {
                return Optional.ofNullable(clazz.cast(this.findingArns()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddAttributesToFindingsRequest, T> g) {
        return obj -> g.apply((AddAttributesToFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> findingArns = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttributesToFindingsRequest model) {
            super(model);
            this.findingArns(model.findingArns);
            this.attributes(model.attributes);
        }

        public final Collection<String> getFindingArns() {
            if (this.findingArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingArns;
        }

        @Override
        public final Builder findingArns(Collection<String> findingArns) {
            this.findingArns = AddRemoveAttributesFindingArnListCopier.copy(findingArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArns(String ... findingArns) {
            this.findingArns(Arrays.asList(findingArns));
            return this;
        }

        public final void setFindingArns(Collection<String> findingArns) {
            this.findingArns = AddRemoveAttributesFindingArnListCopier.copy(findingArns);
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = UserAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = UserAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = UserAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddAttributesToFindingsRequest build() {
            return new AddAttributesToFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddAttributesToFindingsRequest> {
        public Builder findingArns(Collection<String> var1);

        public Builder findingArns(String ... var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

