/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a resource group. The resource group defines a set of tags that, when queried, identify
 * the AWS resources that make up the assessment target. This data type is used as the response element in the
 * <a>DescribeResourceGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceGroup implements SdkPojo, Serializable, ToCopyableBuilder<ResourceGroup.Builder, ResourceGroup> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<ResourceGroupTag>> TAGS_FIELD = SdkField
            .<List<ResourceGroupTag>> builder(MarshallingType.LIST)
            .getter(getter(ResourceGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceGroupTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceGroupTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ResourceGroup::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TAGS_FIELD,
            CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<ResourceGroupTag> tags;

    private final Instant createdAt;

    private ResourceGroup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The ARN of the resource group.
     * </p>
     * 
     * @return The ARN of the resource group.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags (key and value pairs) of the resource group. This data type property is used in the
     * <a>CreateResourceGroup</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags (key and value pairs) of the resource group. This data type property is used in the
     *         <a>CreateResourceGroup</a> action.
     */
    public List<ResourceGroupTag> tags() {
        return tags;
    }

    /**
     * <p>
     * The time at which resource group is created.
     * </p>
     * 
     * @return The time at which resource group is created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceGroup)) {
            return false;
        }
        ResourceGroup other = (ResourceGroup) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(tags(), other.tags())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceGroup").add("Arn", arn()).add("Tags", tags()).add("CreatedAt", createdAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceGroup, T> g) {
        return obj -> g.apply((ResourceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceGroup> {
        /**
         * <p>
         * The ARN of the resource group.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The tags (key and value pairs) of the resource group. This data type property is used in the
         * <a>CreateResourceGroup</a> action.
         * </p>
         * 
         * @param tags
         *        The tags (key and value pairs) of the resource group. This data type property is used in the
         *        <a>CreateResourceGroup</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<ResourceGroupTag> tags);

        /**
         * <p>
         * The tags (key and value pairs) of the resource group. This data type property is used in the
         * <a>CreateResourceGroup</a> action.
         * </p>
         * 
         * @param tags
         *        The tags (key and value pairs) of the resource group. This data type property is used in the
         *        <a>CreateResourceGroup</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(ResourceGroupTag... tags);

        /**
         * <p>
         * The tags (key and value pairs) of the resource group. This data type property is used in the
         * <a>CreateResourceGroup</a> action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceGroupTag>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceGroupTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceGroupTag>.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<ResourceGroupTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<ResourceGroupTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<ResourceGroupTag>)
         */
        Builder tags(Consumer<ResourceGroupTag.Builder>... tags);

        /**
         * <p>
         * The time at which resource group is created.
         * </p>
         * 
         * @param createdAt
         *        The time at which resource group is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<ResourceGroupTag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceGroup model) {
            arn(model.arn);
            tags(model.tags);
            createdAt(model.createdAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<ResourceGroupTag.Builder> getTags() {
            return tags != null ? tags.stream().map(ResourceGroupTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<ResourceGroupTag> tags) {
            this.tags = ResourceGroupTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(ResourceGroupTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<ResourceGroupTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> ResourceGroupTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<ResourceGroupTag.BuilderImpl> tags) {
            this.tags = ResourceGroupTagsCopier.copyFromBuilder(tags);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public ResourceGroup build() {
            return new ResourceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
