/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventSubscriptionsResponse extends InspectorResponse implements
        ToCopyableBuilder<ListEventSubscriptionsResponse.Builder, ListEventSubscriptionsResponse> {
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .getter(getter(ListEventSubscriptionsResponse::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEventSubscriptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Subscription> subscriptions;

    private final String nextToken;

    private ListEventSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Subscriptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the returned event subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details of the returned event subscriptions.
     */
    public List<Subscription> subscriptions() {
        return subscriptions;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameter is present in the response and
     * contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no
     * more data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameter is present in the
     *         response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
     *         request. If there is no more data to be listed, this parameter is set to null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSubscriptionsResponse)) {
            return false;
        }
        ListEventSubscriptionsResponse other = (ListEventSubscriptionsResponse) obj;
        return Objects.equals(subscriptions(), other.subscriptions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEventSubscriptionsResponse").add("Subscriptions", subscriptions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListEventSubscriptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventSubscriptionsResponse> {
        /**
         * <p>
         * Details of the returned event subscriptions.
         * </p>
         * 
         * @param subscriptions
         *        Details of the returned event subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * <p>
         * Details of the returned event subscriptions.
         * </p>
         * 
         * @param subscriptions
         *        Details of the returned event subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Subscription... subscriptions);

        /**
         * <p>
         * Details of the returned event subscriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Subscription>.Builder} avoiding the need to
         * create one manually via {@link List<Subscription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subscription>.Builder#build()} is called immediately and its
         * result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on {@link List<Subscription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(List<Subscription>)
         */
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameter is present in the response
         * and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there
         * is no more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameter is present in the
         *        response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
         *        request. If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSubscriptionsResponse model) {
            super(model);
            subscriptions(model.subscriptions);
            nextToken(model.nextToken);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return subscriptions != null ? subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventSubscriptionsResponse build() {
            return new ListEventSubscriptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
