/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a request parameter in the <a>ListFindings</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingFilter implements SdkPojo, Serializable, ToCopyableBuilder<FindingFilter.Builder, FindingFilter> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::agentIds))
            .setter(setter(Builder::agentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::ruleNames))
            .setter(setter(Builder::ruleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::severitiesAsStrings))
            .setter(setter(Builder::severitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::rulesPackageArns))
            .setter(setter(Builder::rulesPackageArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(FindingFilter::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimestampRange> CREATION_TIME_RANGE_FIELD = SdkField
            .<TimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(FindingFilter::creationTimeRange))
            .setter(setter(Builder::creationTimeRange)).constructor(TimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD,
            AUTO_SCALING_GROUPS_FIELD, RULE_NAMES_FIELD, SEVERITIES_FIELD, RULES_PACKAGE_ARNS_FIELD, ATTRIBUTES_FIELD,
            USER_ATTRIBUTES_FIELD, CREATION_TIME_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> agentIds;

    private final List<String> autoScalingGroups;

    private final List<String> ruleNames;

    private final List<String> severities;

    private final List<String> rulesPackageArns;

    private final List<Attribute> attributes;

    private final List<Attribute> userAttributes;

    private final TimestampRange creationTimeRange;

    private FindingFilter(BuilderImpl builder) {
        this.agentIds = builder.agentIds;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.ruleNames = builder.ruleNames;
        this.severities = builder.severities;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.attributes = builder.attributes;
        this.userAttributes = builder.userAttributes;
        this.creationTimeRange = builder.creationTimeRange;
    }

    /**
     * Returns true if the AgentIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAgentIds() {
        return agentIds != null && !(agentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, one of the values that is specified for this data type property must be the exact
     * match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgentIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, one of the values that is specified for this data type property must be
     *         the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.
     */
    public List<String> agentIds() {
        return agentIds;
    }

    /**
     * Returns true if the AutoScalingGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAutoScalingGroups() {
        return autoScalingGroups != null && !(autoScalingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, one of the values that is specified for this data type property must be the exact
     * match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoScalingGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, one of the values that is specified for this data type property must be
     *         the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data type.
     */
    public List<String> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * Returns true if the RuleNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRuleNames() {
        return ruleNames != null && !(ruleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, one of the values that is specified for this data type property must be the exact
     * match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, one of the values that is specified for this data type property must be
     *         the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.
     */
    public List<String> ruleNames() {
        return ruleNames;
    }

    /**
     * <p>
     * For a record to match a filter, one of the values that is specified for this data type property must be the exact
     * match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, one of the values that is specified for this data type property must be
     *         the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
     */
    public List<Severity> severities() {
        return SeverityListCopier.copyStringToEnum(severities);
    }

    /**
     * Returns true if the Severities property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSeverities() {
        return severities != null && !(severities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, one of the values that is specified for this data type property must be the exact
     * match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, one of the values that is specified for this data type property must be
     *         the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
     */
    public List<String> severitiesAsStrings() {
        return severities;
    }

    /**
     * Returns true if the RulesPackageArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRulesPackageArns() {
        return rulesPackageArns != null && !(rulesPackageArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, one of the values that is specified for this data type property must be the exact
     * match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRulesPackageArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, one of the values that is specified for this data type property must be
     *         the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data type.
     */
    public List<String> rulesPackageArns() {
        return rulesPackageArns;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, the list of values that are specified for this data type property must be
     * contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, the list of values that are specified for this data type property must be
     *         contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
     */
    public List<Attribute> attributes() {
        return attributes;
    }

    /**
     * Returns true if the UserAttributes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserAttributes() {
        return userAttributes != null && !(userAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a record to match a filter, the value that is specified for this data type property must be contained in the
     * list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a record to match a filter, the value that is specified for this data type property must be contained
     *         in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
     */
    public List<Attribute> userAttributes() {
        return userAttributes;
    }

    /**
     * <p>
     * The time range during which the finding is generated.
     * </p>
     * 
     * @return The time range during which the finding is generated.
     */
    public TimestampRange creationTimeRange() {
        return creationTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentIds());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNames());
        hashCode = 31 * hashCode + Objects.hashCode(severitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(rulesPackageArns());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingFilter)) {
            return false;
        }
        FindingFilter other = (FindingFilter) obj;
        return Objects.equals(agentIds(), other.agentIds()) && Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(ruleNames(), other.ruleNames())
                && Objects.equals(severitiesAsStrings(), other.severitiesAsStrings())
                && Objects.equals(rulesPackageArns(), other.rulesPackageArns())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(userAttributes(), other.userAttributes())
                && Objects.equals(creationTimeRange(), other.creationTimeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FindingFilter").add("AgentIds", agentIds()).add("AutoScalingGroups", autoScalingGroups())
                .add("RuleNames", ruleNames()).add("Severities", severitiesAsStrings())
                .add("RulesPackageArns", rulesPackageArns()).add("Attributes", attributes())
                .add("UserAttributes", userAttributes()).add("CreationTimeRange", creationTimeRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentIds":
            return Optional.ofNullable(clazz.cast(agentIds()));
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "ruleNames":
            return Optional.ofNullable(clazz.cast(ruleNames()));
        case "severities":
            return Optional.ofNullable(clazz.cast(severitiesAsStrings()));
        case "rulesPackageArns":
            return Optional.ofNullable(clazz.cast(rulesPackageArns()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "userAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "creationTimeRange":
            return Optional.ofNullable(clazz.cast(creationTimeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingFilter, T> g) {
        return obj -> g.apply((FindingFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingFilter> {
        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param agentIds
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(Collection<String> agentIds);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param agentIds
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(String... agentIds);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param autoScalingGroups
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<String> autoScalingGroups);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param autoScalingGroups
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(String... autoScalingGroups);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param ruleNames
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(Collection<String> ruleNames);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param ruleNames
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(String... ruleNames);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param severities
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(Collection<String> severities);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param severities
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitiesWithStrings(String... severities);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param severities
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(Collection<Severity> severities);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param severities
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(Severity... severities);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param rulesPackageArns
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(Collection<String> rulesPackageArns);

        /**
         * <p>
         * For a record to match a filter, one of the values that is specified for this data type property must be the
         * exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param rulesPackageArns
         *        For a record to match a filter, one of the values that is specified for this data type property must
         *        be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(String... rulesPackageArns);

        /**
         * <p>
         * For a record to match a filter, the list of values that are specified for this data type property must be
         * contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param attributes
         *        For a record to match a filter, the list of values that are specified for this data type property must
         *        be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * For a record to match a filter, the list of values that are specified for this data type property must be
         * contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param attributes
         *        For a record to match a filter, the list of values that are specified for this data type property must
         *        be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * For a record to match a filter, the list of values that are specified for this data type property must be
         * contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must be contained in
         * the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param userAttributes
         *        For a record to match a filter, the value that is specified for this data type property must be
         *        contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Collection<Attribute> userAttributes);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must be contained in
         * the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
         * </p>
         * 
         * @param userAttributes
         *        For a record to match a filter, the value that is specified for this data type property must be
         *        contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Attribute... userAttributes);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must be contained in
         * the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #userAttributes(List<Attribute>)}.
         * 
         * @param userAttributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributes(List<Attribute>)
         */
        Builder userAttributes(Consumer<Attribute.Builder>... userAttributes);

        /**
         * <p>
         * The time range during which the finding is generated.
         * </p>
         * 
         * @param creationTimeRange
         *        The time range during which the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeRange(TimestampRange creationTimeRange);

        /**
         * <p>
         * The time range during which the finding is generated.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampRange.Builder} avoiding the need to
         * create one manually via {@link TimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #creationTimeRange(TimestampRange)}.
         * 
         * @param creationTimeRange
         *        a consumer that will call methods on {@link TimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creationTimeRange(TimestampRange)
         */
        default Builder creationTimeRange(Consumer<TimestampRange.Builder> creationTimeRange) {
            return creationTimeRange(TimestampRange.builder().applyMutation(creationTimeRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> severities = DefaultSdkAutoConstructList.getInstance();

        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> userAttributes = DefaultSdkAutoConstructList.getInstance();

        private TimestampRange creationTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingFilter model) {
            agentIds(model.agentIds);
            autoScalingGroups(model.autoScalingGroups);
            ruleNames(model.ruleNames);
            severitiesWithStrings(model.severities);
            rulesPackageArns(model.rulesPackageArns);
            attributes(model.attributes);
            userAttributes(model.userAttributes);
            creationTimeRange(model.creationTimeRange);
        }

        public final Collection<String> getAgentIds() {
            return agentIds;
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdListCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String... agentIds) {
            agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdListCopier.copy(agentIds);
        }

        public final Collection<String> getAutoScalingGroups() {
            return autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
        }

        public final Collection<String> getRuleNames() {
            return ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String... ruleNames) {
            ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
        }

        public final Collection<String> getSeverities() {
            return severities;
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = SeverityListCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String... severities) {
            severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<Severity> severities) {
            this.severities = SeverityListCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(Severity... severities) {
            severities(Arrays.asList(severities));
            return this;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = SeverityListCopier.copy(severities);
        }

        public final Collection<String> getRulesPackageArns() {
            return rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String... rulesPackageArns) {
            rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        public final Collection<Attribute.Builder> getUserAttributes() {
            return userAttributes != null ? userAttributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<Attribute> userAttributes) {
            this.userAttributes = AttributeListCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Attribute... userAttributes) {
            userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<Attribute.Builder>... userAttributes) {
            userAttributes(Stream.of(userAttributes).map(c -> Attribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<Attribute.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListCopier.copyFromBuilder(userAttributes);
        }

        public final TimestampRange.Builder getCreationTimeRange() {
            return creationTimeRange != null ? creationTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder creationTimeRange(TimestampRange creationTimeRange) {
            this.creationTimeRange = creationTimeRange;
            return this;
        }

        public final void setCreationTimeRange(TimestampRange.BuilderImpl creationTimeRange) {
            this.creationTimeRange = creationTimeRange != null ? creationTimeRange.build() : null;
        }

        @Override
        public FindingFilter build() {
            return new FindingFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
