/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the network interfaces interacting with an EC2 instance. This data type is used as one of
 * the elements of the <a>AssetAttributes</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceId").build())
            .build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateDnsName)).setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateIpAddress)).setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<List<PrivateIp>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIp>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivateIp> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::publicDnsName)).setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDnsName").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIp").build()).build();

    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SecurityGroup>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            SUBNET_ID_FIELD, VPC_ID_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD, IPV6_ADDRESSES_FIELD, SECURITY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInterfaceId;

    private final String subnetId;

    private final String vpcId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<PrivateIp> privateIpAddresses;

    private final String publicDnsName;

    private final String publicIp;

    private final List<String> ipv6Addresses;

    private final List<SecurityGroup> securityGroups;

    private NetworkInterface(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of a subnet associated with the network interface.
     * </p>
     * 
     * @return The ID of a subnet associated with the network interface.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of a VPC associated with the network interface.
     * </p>
     * 
     * @return The ID of a VPC associated with the network interface.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of a private DNS associated with the network interface.
     * </p>
     * 
     * @return The name of a private DNS associated with the network interface.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IP address associated with the network interface.
     * </p>
     * 
     * @return The private IP address associated with the network interface.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * Returns true if the PrivateIpAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the private IP addresses associated with the network interface. Includes the privateDnsName and
     * privateIpAddress.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrivateIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the private IP addresses associated with the network interface. Includes the privateDnsName and
     *         privateIpAddress.
     */
    public List<PrivateIp> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The name of a public DNS associated with the network interface.
     * </p>
     * 
     * @return The name of a public DNS associated with the network interface.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IP address from which the network interface is reachable.
     * </p>
     * 
     * @return The public IP address from which the network interface is reachable.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * Returns true if the Ipv6Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IP addresses associated with the network interface.
     */
    public List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the security groups associated with the network interface. Includes the groupId and groupName.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the security groups associated with the network interface. Includes the groupId and groupName.
     */
    public List<SecurityGroup> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(publicDnsName(), other.publicDnsName()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(securityGroups(), other.securityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInterface").add("NetworkInterfaceId", networkInterfaceId()).add("SubnetId", subnetId())
                .add("VpcId", vpcId()).add("PrivateDnsName", privateDnsName()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", privateIpAddresses()).add("PublicDnsName", publicDnsName())
                .add("PublicIp", publicIp()).add("Ipv6Addresses", ipv6Addresses()).add("SecurityGroups", securityGroups())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "privateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "privateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "privateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "publicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "publicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "securityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of a subnet associated with the network interface.
         * </p>
         * 
         * @param subnetId
         *        The ID of a subnet associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of a VPC associated with the network interface.
         * </p>
         * 
         * @param vpcId
         *        The ID of a VPC associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of a private DNS associated with the network interface.
         * </p>
         * 
         * @param privateDnsName
         *        The name of a private DNS associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IP address associated with the network interface.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * A list of the private IP addresses associated with the network interface. Includes the privateDnsName and
         * privateIpAddress.
         * </p>
         * 
         * @param privateIpAddresses
         *        A list of the private IP addresses associated with the network interface. Includes the privateDnsName
         *        and privateIpAddress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIp> privateIpAddresses);

        /**
         * <p>
         * A list of the private IP addresses associated with the network interface. Includes the privateDnsName and
         * privateIpAddress.
         * </p>
         * 
         * @param privateIpAddresses
         *        A list of the private IP addresses associated with the network interface. Includes the privateDnsName
         *        and privateIpAddress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIp... privateIpAddresses);

        /**
         * <p>
         * A list of the private IP addresses associated with the network interface. Includes the privateDnsName and
         * privateIpAddress.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrivateIp>.Builder} avoiding the need to
         * create one manually via {@link List<PrivateIp>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrivateIp>.Builder#build()} is called immediately and its
         * result is passed to {@link #privateIpAddresses(List<PrivateIp>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<PrivateIp>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<PrivateIp>)
         */
        Builder privateIpAddresses(Consumer<PrivateIp.Builder>... privateIpAddresses);

        /**
         * <p>
         * The name of a public DNS associated with the network interface.
         * </p>
         * 
         * @param publicDnsName
         *        The name of a public DNS associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IP address from which the network interface is reachable.
         * </p>
         * 
         * @param publicIp
         *        The public IP address from which the network interface is reachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The IP addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IP addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * The IP addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IP addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * A list of the security groups associated with the network interface. Includes the groupId and groupName.
         * </p>
         * 
         * @param securityGroups
         *        A list of the security groups associated with the network interface. Includes the groupId and
         *        groupName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroup> securityGroups);

        /**
         * <p>
         * A list of the security groups associated with the network interface. Includes the groupId and groupName.
         * </p>
         * 
         * @param securityGroups
         *        A list of the security groups associated with the network interface. Includes the groupId and
         *        groupName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroup... securityGroups);

        /**
         * <p>
         * A list of the security groups associated with the network interface. Includes the groupId and groupName.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroup>.Builder} avoiding the need
         * to create one manually via {@link List<SecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #securityGroups(List<SecurityGroup>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<SecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<SecurityGroup>)
         */
        Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceId;

        private String subnetId;

        private String vpcId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<PrivateIp> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String publicDnsName;

        private String publicIp;

        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<SecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            networkInterfaceId(model.networkInterfaceId);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
            ipv6Addresses(model.ipv6Addresses);
            securityGroups(model.securityGroups);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<PrivateIp.Builder> getPrivateIpAddresses() {
            return privateIpAddresses != null ? privateIpAddresses.stream().map(PrivateIp::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIp> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIp... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIp.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses).map(c -> PrivateIp.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIp.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copyFromBuilder(privateIpAddresses);
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final Collection<String> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
        }

        public final Collection<SecurityGroup.Builder> getSecurityGroups() {
            return securityGroups != null ? securityGroups.stream().map(SecurityGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
