/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds;

import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.imds.internal.unmarshall.document.DocumentUnmarshaller;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeVisitor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class Ec2MetadataResponse {
    private static final JsonNodeParser JSON_NODE_PARSER = JsonNode.parserBuilder().removeErrorLocations(true).build();
    private final String body;

    private Ec2MetadataResponse(String body) {
        this.body = (String)Validate.notNull((Object)body, (String)"Metadata is null", (Object[])new Object[0]);
    }

    public static Ec2MetadataResponse create(String body) {
        return new Ec2MetadataResponse(body);
    }

    public String asString() {
        return this.body;
    }

    public List<String> asList() {
        return Arrays.asList(this.body.split("\n"));
    }

    public Document asDocument() {
        JsonNode node = JSON_NODE_PARSER.parse(this.body);
        return (Document)node.visit((JsonNodeVisitor)new DocumentUnmarshaller());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ec2MetadataResponse that = (Ec2MetadataResponse)o;
        return this.body.equals(that.body);
    }

    public int hashCode() {
        return this.body.hashCode();
    }

    public String toString() {
        return ToString.builder((String)"MetadataResponse").add("body", (Object)this.body).build();
    }
}

