/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.imds.EndpointMode;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class Ec2MetadataEndpointProvider {
    private static final Ec2MetadataEndpointProvider DEFAULT_ENDPOINT_PROVIDER = Ec2MetadataEndpointProvider.builder().build();
    private static final EnumMap<EndpointMode, String> DEFAULT_ENDPOINT_MODE = new EnumMap(EndpointMode.class);
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;

    private Ec2MetadataEndpointProvider(Builder builder) {
        this.profileFile = builder.profileFile;
        this.profileName = builder.profileName;
    }

    public static Ec2MetadataEndpointProvider instance() {
        return DEFAULT_ENDPOINT_PROVIDER;
    }

    public String resolveEndpoint(EndpointMode endpointMode) {
        Optional endpointFromSystem = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getNonDefaultStringValue();
        if (endpointFromSystem.isPresent()) {
            return Ec2MetadataEndpointProvider.stripEndingSlash((String)endpointFromSystem.get());
        }
        Optional endpointFromConfigProfile = this.resolveProfile().flatMap(profile -> profile.property("ec2_metadata_service_endpoint"));
        if (endpointFromConfigProfile.isPresent()) {
            return Ec2MetadataEndpointProvider.stripEndingSlash((String)endpointFromConfigProfile.get());
        }
        Validate.notNull((Object)((Object)endpointMode), (String)"endpointMode must not be null.", (Object[])new Object[0]);
        return endpointFromConfigProfile.orElseGet(() -> DEFAULT_ENDPOINT_MODE.get((Object)endpointMode));
    }

    private static String stripEndingSlash(String uri) {
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    public EndpointMode resolveEndpointMode() {
        Optional systemEndpointMode = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE.getNonDefaultStringValue();
        if (systemEndpointMode.isPresent()) {
            return EndpointMode.fromValue((String)systemEndpointMode.get());
        }
        Optional<EndpointMode> configFileEndPointMode = this.resolveProfile().flatMap(p -> p.property("ec2_metadata_service_endpoint_mode")).map(EndpointMode::fromValue);
        if (configFileEndPointMode.isPresent()) {
            return configFileEndPointMode.get();
        }
        String defaultSystemEndpointMode = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE.defaultValue();
        return EndpointMode.fromValue(defaultSystemEndpointMode);
    }

    public Optional<Profile> resolveProfile() {
        String profileNameToUse = this.profileName == null ? ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow() : this.profileName;
        ProfileFile profileFileToUse = this.profileFile.get();
        return profileFileToUse.profile(profileNameToUse);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT_ENDPOINT_MODE.put(EndpointMode.IPV4, "http://169.254.169.254");
        DEFAULT_ENDPOINT_MODE.put(EndpointMode.IPV6, "http://[fd00:ec2::254]");
    }

    public static final class Builder {
        private Supplier<ProfileFile> profileFile = ProfileFile::defaultProfileFile;
        private String profileName;

        private Builder() {
        }

        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            Validate.notNull(profileFile, (String)"profileFile Supplier must not be null", (Object[])new Object[0]);
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Ec2MetadataEndpointProvider build() {
            return new Ec2MetadataEndpointProvider(this);
        }
    }
}

