/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionRollbackStatus;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowStepMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowStepMetadata> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepExecutionId").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::stepExecutionId)).setter(WorkflowStepMetadata.setter(Builder::stepExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepExecutionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::name)).setter(WorkflowStepMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::description)).setter(WorkflowStepMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::action)).setter(WorkflowStepMetadata.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::statusAsString)).setter(WorkflowStepMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ROLLBACK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rollbackStatus").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::rollbackStatusAsString)).setter(WorkflowStepMetadata.setter(Builder::rollbackStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::message)).setter(WorkflowStepMetadata.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputs").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::inputs)).setter(WorkflowStepMetadata.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build()}).build();
    private static final SdkField<String> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputs").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::outputs)).setter(WorkflowStepMetadata.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startTime").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::startTime)).setter(WorkflowStepMetadata.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endTime").getter(WorkflowStepMetadata.getter(WorkflowStepMetadata::endTime)).setter(WorkflowStepMetadata.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, STATUS_FIELD, ROLLBACK_STATUS_FIELD, MESSAGE_FIELD, INPUTS_FIELD, OUTPUTS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowStepMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stepExecutionId;
    private final String name;
    private final String description;
    private final String action;
    private final String status;
    private final String rollbackStatus;
    private final String message;
    private final String inputs;
    private final String outputs;
    private final String startTime;
    private final String endTime;

    private WorkflowStepMetadata(BuilderImpl builder) {
        this.stepExecutionId = builder.stepExecutionId;
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.status = builder.status;
        this.rollbackStatus = builder.rollbackStatus;
        this.message = builder.message;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String stepExecutionId() {
        return this.stepExecutionId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String action() {
        return this.action;
    }

    public final WorkflowStepExecutionStatus status() {
        return WorkflowStepExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final WorkflowStepExecutionRollbackStatus rollbackStatus() {
        return WorkflowStepExecutionRollbackStatus.fromValue(this.rollbackStatus);
    }

    public final String rollbackStatusAsString() {
        return this.rollbackStatus;
    }

    public final String message() {
        return this.message;
    }

    public final String inputs() {
        return this.inputs;
    }

    public final String outputs() {
        return this.outputs;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepMetadata)) {
            return false;
        }
        WorkflowStepMetadata other = (WorkflowStepMetadata)obj;
        return Objects.equals(this.stepExecutionId(), other.stepExecutionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.rollbackStatusAsString(), other.rollbackStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowStepMetadata").add("StepExecutionId", (Object)this.stepExecutionId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Action", (Object)this.action()).add("Status", (Object)this.statusAsString()).add("RollbackStatus", (Object)this.rollbackStatusAsString()).add("Message", (Object)this.message()).add("Inputs", (Object)this.inputs()).add("Outputs", (Object)this.outputs()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepExecutionId": {
                return Optional.ofNullable(clazz.cast(this.stepExecutionId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "rollbackStatus": {
                return Optional.ofNullable(clazz.cast(this.rollbackStatusAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("rollbackStatus", ROLLBACK_STATUS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepMetadata, T> g) {
        return obj -> g.apply((WorkflowStepMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepExecutionId;
        private String name;
        private String description;
        private String action;
        private String status;
        private String rollbackStatus;
        private String message;
        private String inputs;
        private String outputs;
        private String startTime;
        private String endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepMetadata model) {
            this.stepExecutionId(model.stepExecutionId);
            this.name(model.name);
            this.description(model.description);
            this.action(model.action);
            this.status(model.status);
            this.rollbackStatus(model.rollbackStatus);
            this.message(model.message);
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getStepExecutionId() {
            return this.stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStepExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRollbackStatus() {
            return this.rollbackStatus;
        }

        public final void setRollbackStatus(String rollbackStatus) {
            this.rollbackStatus = rollbackStatus;
        }

        @Override
        public final Builder rollbackStatus(String rollbackStatus) {
            this.rollbackStatus = rollbackStatus;
            return this;
        }

        @Override
        public final Builder rollbackStatus(WorkflowStepExecutionRollbackStatus rollbackStatus) {
            this.rollbackStatus(rollbackStatus == null ? null : rollbackStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getInputs() {
            return this.inputs;
        }

        public final void setInputs(String inputs) {
            this.inputs = inputs;
        }

        @Override
        public final Builder inputs(String inputs) {
            this.inputs = inputs;
            return this;
        }

        public final String getOutputs() {
            return this.outputs;
        }

        public final void setOutputs(String outputs) {
            this.outputs = outputs;
        }

        @Override
        public final Builder outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public WorkflowStepMetadata build() {
            return new WorkflowStepMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowStepMetadata> {
        public Builder stepExecutionId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder action(String var1);

        public Builder status(String var1);

        public Builder status(WorkflowStepExecutionStatus var1);

        public Builder rollbackStatus(String var1);

        public Builder rollbackStatus(WorkflowStepExecutionRollbackStatus var1);

        public Builder message(String var1);

        public Builder inputs(String var1);

        public Builder outputs(String var1);

        public Builder startTime(String var1);

        public Builder endTime(String var1);
    }
}

